/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.extension.notify.email;

import jakarta.mail.internet.MimeMessage;
import java.util.Date;
import lombok.Generated;
import org.dromara.dynamictp.common.em.NotifyPlatformEnum;
import org.dromara.dynamictp.common.entity.NotifyPlatform;
import org.dromara.dynamictp.common.notifier.AbstractNotifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;

public class EmailNotifier
extends AbstractNotifier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmailNotifier.class);
    @Value(value="${spring.mail.username}")
    private String sendFrom;
    @Value(value="${spring.mail.title:ThreadPool Notify}")
    private String title;
    private final JavaMailSender javaMailSender;
    private final TemplateEngine templateEngine;

    public EmailNotifier(JavaMailSender javaMailSender, TemplateEngine templateEngine) {
        this.javaMailSender = javaMailSender;
        this.templateEngine = templateEngine;
    }

    public String platform() {
        return NotifyPlatformEnum.EMAIL.name().toLowerCase();
    }

    protected void send0(NotifyPlatform platform, String content) {
        MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
        MimeMessageHelper messageHelper = new MimeMessageHelper(mimeMessage, true, "UTF-8");
        messageHelper.setSubject(this.title);
        messageHelper.setFrom(this.sendFrom);
        messageHelper.setTo(platform.getReceivers());
        messageHelper.setSentDate(new Date());
        messageHelper.setText(content, true);
        this.javaMailSender.send(mimeMessage);
        log.info("DynamicTp notify, {} send success.", (Object)this.platform());
    }

    public String processTemplateContent(String template, Context context) {
        return this.templateEngine.process(template, (IContext)context);
    }
}

