/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.extension.notify.email;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.dromara.dynamictp.common.em.NotifyItemEnum;
import org.dromara.dynamictp.common.em.NotifyPlatformEnum;
import org.dromara.dynamictp.common.entity.NotifyItem;
import org.dromara.dynamictp.common.entity.NotifyPlatform;
import org.dromara.dynamictp.common.entity.TpMainFields;
import org.dromara.dynamictp.common.manager.ContextManagerHelper;
import org.dromara.dynamictp.common.notifier.Notifier;
import org.dromara.dynamictp.common.util.CommonUtil;
import org.dromara.dynamictp.common.util.DateUtil;
import org.dromara.dynamictp.core.notifier.AbstractDtpNotifier;
import org.dromara.dynamictp.core.notifier.alarm.AlarmCounter;
import org.dromara.dynamictp.core.notifier.context.AlarmCtx;
import org.dromara.dynamictp.core.notifier.context.BaseNotifyCtx;
import org.dromara.dynamictp.core.notifier.context.DtpNotifyCtxHolder;
import org.dromara.dynamictp.core.notifier.manager.NotifyHelper;
import org.dromara.dynamictp.core.support.ExecutorWrapper;
import org.dromara.dynamictp.core.support.ThreadPoolStatProvider;
import org.dromara.dynamictp.core.support.adapter.ExecutorAdapter;
import org.dromara.dynamictp.extension.notify.email.EmailNotifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.context.Context;

public class DtpEmailNotifier
extends AbstractDtpNotifier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DtpEmailNotifier.class);

    public DtpEmailNotifier() {
        super((Notifier)ContextManagerHelper.getBean(EmailNotifier.class));
    }

    public String platform() {
        return NotifyPlatformEnum.EMAIL.name().toLowerCase();
    }

    protected String getNoticeTemplate() {
        return null;
    }

    protected String getAlarmTemplate() {
        return null;
    }

    protected Pair<String, String> getColors() {
        return null;
    }

    protected String buildAlarmContent(NotifyPlatform platform, NotifyItemEnum notifyItemEnum) {
        AlarmCtx alarmCtx = (AlarmCtx)DtpNotifyCtxHolder.get();
        NotifyItem notifyItem = alarmCtx.getNotifyItem();
        ExecutorWrapper executorWrapper = alarmCtx.getExecutorWrapper();
        String threadPoolName = executorWrapper.getThreadPoolName();
        String alarmValue = notifyItem.getCount() + " / " + alarmCtx.getAlarmInfo().getCount();
        String lastAlarmTime = AlarmCounter.getLastAlarmTime((String)threadPoolName, (String)notifyItem.getType());
        ExecutorAdapter executor = executorWrapper.getExecutor();
        ThreadPoolStatProvider statProvider = executorWrapper.getThreadPoolStatProvider();
        Context context = this.newContext(executorWrapper);
        context.setVariable("alarmType", (Object)this.populateAlarmItem(notifyItemEnum, notifyItem, executorWrapper));
        context.setVariable("alarmValue", (Object)alarmValue);
        context.setVariable("corePoolSize", (Object)executor.getCorePoolSize());
        context.setVariable("maximumPoolSize", (Object)executor.getMaximumPoolSize());
        context.setVariable("poolSize", (Object)executor.getPoolSize());
        context.setVariable("activeCount", (Object)executor.getActiveCount());
        context.setVariable("largestPoolSize", (Object)executor.getLargestPoolSize());
        context.setVariable("taskCount", (Object)executor.getTaskCount());
        context.setVariable("completedTaskCount", (Object)executor.getCompletedTaskCount());
        context.setVariable("waitingTaskCount", (Object)executor.getQueueSize());
        context.setVariable("queueType", (Object)executor.getQueueType());
        context.setVariable("queueCapacity", (Object)executor.getQueueCapacity());
        context.setVariable("queueSize", (Object)executor.getQueueSize());
        context.setVariable("queueRemaining", (Object)executor.getQueueRemainingCapacity());
        context.setVariable("rejectType", (Object)executor.getRejectHandlerType());
        context.setVariable("rejectCount", (Object)statProvider.getRejectedTaskCount());
        context.setVariable("runTimeoutCount", (Object)statProvider.getRunTimeoutCount());
        context.setVariable("queueTimeoutCount", (Object)statProvider.getQueueTimeoutCount());
        context.setVariable("lastAlarmTime", (Object)Optional.ofNullable(lastAlarmTime).orElse("---"));
        context.setVariable("alarmTime", (Object)DateUtil.now());
        context.setVariable("alarmPeriod", (Object)notifyItem.getPeriod());
        context.setVariable("alarmSilencePeriod", (Object)notifyItem.getSilencePeriod());
        context.setVariable("highlightVariables", (Object)NotifyHelper.getAlarmKeys((NotifyItemEnum)notifyItemEnum));
        context.setVariable("trace", (Object)this.getTraceInfo());
        context.setVariable("ext", (Object)this.getExtInfo());
        return ((EmailNotifier)this.notifier).processTemplateContent("alarm", context);
    }

    protected String buildNoticeContent(NotifyPlatform platform, TpMainFields oldFields, List<String> diffs) {
        BaseNotifyCtx notifyCtx = DtpNotifyCtxHolder.get();
        ExecutorWrapper executorWrapper = notifyCtx.getExecutorWrapper();
        ExecutorAdapter executor = executorWrapper.getExecutor();
        Context context = this.newContext(executorWrapper);
        context.setVariable("oldCorePoolSize", (Object)oldFields.getCorePoolSize());
        context.setVariable("newCorePoolSize", (Object)executor.getCorePoolSize());
        context.setVariable("oldMaxPoolSize", (Object)oldFields.getMaxPoolSize());
        context.setVariable("newMaxPoolSize", (Object)executor.getMaximumPoolSize());
        context.setVariable("oldIsAllowCoreThreadTimeOut", (Object)oldFields.isAllowCoreThreadTimeOut());
        context.setVariable("newIsAllowCoreThreadTimeOut", (Object)executor.allowsCoreThreadTimeOut());
        context.setVariable("oldKeepAliveTime", (Object)oldFields.getKeepAliveTime());
        context.setVariable("newKeepAliveTime", (Object)executor.getKeepAliveTime(TimeUnit.SECONDS));
        context.setVariable("queueType", (Object)executor.getQueueType());
        context.setVariable("oldQueueCapacity", (Object)oldFields.getQueueCapacity());
        context.setVariable("newQueueCapacity", (Object)executor.getQueueCapacity());
        context.setVariable("oldRejectType", (Object)oldFields.getRejectType());
        context.setVariable("newRejectType", (Object)executor.getRejectHandlerType());
        context.setVariable("notifyTime", (Object)DateUtil.now());
        context.setVariable("diffs", diffs != null ? diffs : Collections.emptySet());
        return ((EmailNotifier)this.notifier).processTemplateContent("notice", context);
    }

    private Context newContext(ExecutorWrapper executorWrapper) {
        Context context = new Context();
        context.setVariable("serviceName", (Object)CommonUtil.getInstance().getServiceName());
        context.setVariable("serviceAddress", (Object)(CommonUtil.getInstance().getIp() + ":" + CommonUtil.getInstance().getPort()));
        context.setVariable("serviceEnv", (Object)CommonUtil.getInstance().getEnv());
        context.setVariable("poolName", (Object)this.populatePoolName(executorWrapper));
        return context;
    }
}

