/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.common.util;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public final class StreamUtil {
    private StreamUtil() {
    }

    public static <I, T> List<I> fetchProperty(Collection<T> data, Function<T, I> mapping) {
        Preconditions.checkNotNull(mapping, (Object)"mapping function must not be null");
        if (CollectionUtils.isEmpty(data)) {
            return Collections.emptyList();
        }
        return data.stream().map(mapping).collect(Collectors.toList());
    }

    public static <P, O> Map<O, P> toMap(Collection<P> coll, Function<P, O> key) {
        Preconditions.checkNotNull(key, (Object)"key function must not be null");
        if (CollectionUtils.isEmpty(coll)) {
            return Collections.emptyMap();
        }
        return coll.stream().collect(Collectors.toMap(key, Function.identity(), (v1, v2) -> v2));
    }

    public static <O, D, P> Map<O, P> toMap(Collection<D> list, Function<D, O> key, Function<D, P> value) {
        Preconditions.checkNotNull(key, (Object)"Key function must not be null");
        Preconditions.checkNotNull(value, (Object)"Value function must not be null");
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyMap();
        }
        return list.stream().collect(Collectors.toMap(key, value, (v1, v2) -> v2));
    }

    public static <I, D> Map<I, List<D>> toListMap(Collection<I> ids, Collection<D> list, Function<D, I> key) {
        Preconditions.checkNotNull(key, (Object)"mapping function must not be null");
        if (CollectionUtils.isEmpty(ids) || CollectionUtils.isEmpty(list)) {
            return Collections.emptyMap();
        }
        Map resultMap = list.stream().collect(Collectors.groupingBy(key));
        ids.forEach(id -> resultMap.putIfAbsent(id, Collections.emptyList()));
        return resultMap;
    }
}

