/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.common.notifier;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import java.util.Objects;
import org.dromara.dynamictp.common.entity.NotifyPlatform;
import org.dromara.dynamictp.common.notifier.AbstractNotifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpNotifier
extends AbstractNotifier {
    private static final Logger log = LoggerFactory.getLogger(AbstractHttpNotifier.class);

    @Override
    protected void send0(NotifyPlatform platform, String content) {
        String url = this.buildUrl(platform);
        String msgBody = this.buildMsgBody(platform, content);
        HttpRequest request = HttpRequest.post((String)url).setConnectionTimeout(platform.getTimeout().intValue()).setReadTimeout(platform.getTimeout().intValue()).body(msgBody);
        HttpResponse response = request.execute();
        if (Objects.nonNull(response)) {
            log.info("DynamicTp notify, {} send success, response: {}, request: {}", new Object[]{this.platform(), response.body(), msgBody});
        }
    }

    protected abstract String buildMsgBody(NotifyPlatform var1, String var2);

    protected abstract String buildUrl(NotifyPlatform var1);
}

