/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.common.em;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum JreEnum {
    JAVA_8,
    JAVA_9,
    JAVA_10,
    JAVA_11,
    JAVA_12,
    JAVA_13,
    JAVA_14,
    JAVA_15,
    JAVA_16,
    JAVA_17,
    JAVA_18,
    JAVA_19,
    JAVA_20,
    JAVA_21,
    JAVA_22,
    JAVA_23;

    private static final Logger log;
    private static final JreEnum VERSION;
    public static final String DEFAULT_JAVA_VERSION = "1.8";

    public static JreEnum currentVersion() {
        return VERSION;
    }

    public boolean isCurrentVersion() {
        return this == VERSION;
    }

    private static JreEnum getJre() {
        String version = System.getProperty("java.version");
        boolean isBlank = StringUtils.isBlank((CharSequence)version);
        if (isBlank) {
            log.debug("java.version is blank");
        }
        if (!isBlank && version.startsWith(DEFAULT_JAVA_VERSION)) {
            return JAVA_8;
        }
        try {
            Object javaRunTimeVersion = MethodUtils.invokeMethod((Object)Runtime.getRuntime(), (String)"version");
            int majorVersion = (Integer)MethodUtils.invokeMethod((Object)javaRunTimeVersion, (String)"major");
            return JreEnum.valueOf("JAVA_" + majorVersion);
        }
        catch (Exception e) {
            log.warn("can't determine current JRE version", (Throwable)e);
            return JAVA_8;
        }
    }

    public static boolean greaterThan(JreEnum targetVersion) {
        return JreEnum.getJre().ordinal() > targetVersion.ordinal();
    }

    public static boolean lessThan(JreEnum targetVersion) {
        return JreEnum.getJre().ordinal() < targetVersion.ordinal();
    }

    static {
        log = LoggerFactory.getLogger(JreEnum.class);
        VERSION = JreEnum.getJre();
    }
}

