/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.mysql.packet.commands;

import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import org.drizzle.jdbc.internal.common.Utils;
import org.drizzle.jdbc.internal.common.packet.CommandPacket;
import org.drizzle.jdbc.internal.common.packet.buffer.WriteBuffer;
import org.drizzle.jdbc.internal.mysql.MySQLServerCapabilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLClientAuthPacket
implements CommandPacket {
    private final WriteBuffer writeBuffer;
    private final byte packetSeq;

    public MySQLClientAuthPacket(String username, String password, String database, Set<MySQLServerCapabilities> serverCapabilities, byte[] seed, byte packetSeq) {
        byte[] scrambledPassword;
        this.packetSeq = packetSeq;
        this.writeBuffer = new WriteBuffer();
        try {
            scrambledPassword = Utils.encryptPassword(password, seed);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not use SHA-1, failing", e);
        }
        int serverLanguage = 33;
        this.writeBuffer.writeInt(MySQLServerCapabilities.fromSet(serverCapabilities)).writeInt(0xFFFFFF).writeByte((byte)33).writeBytes((byte)0, 23).writeString(username).writeByte((byte)0).writeByte((byte)scrambledPassword.length).writeByteArray(scrambledPassword).writeString(database).writeByte((byte)0);
    }

    @Override
    public int send(OutputStream os) throws IOException {
        os.write(this.writeBuffer.getLengthWithPacketSeq(this.packetSeq));
        os.write(this.writeBuffer.getBuffer(), 0, this.writeBuffer.getLength());
        os.flush();
        return 1;
    }
}

