/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.drizzle.packet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.drizzle.jdbc.internal.common.ColumnInformation;
import org.drizzle.jdbc.internal.common.ValueObject;
import org.drizzle.jdbc.internal.common.packet.RawPacket;
import org.drizzle.jdbc.internal.common.packet.buffer.Reader;
import org.drizzle.jdbc.internal.drizzle.DrizzleValueObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrizzleRowPacket {
    private final List<ValueObject> columns;

    public DrizzleRowPacket(RawPacket rawPacket, List<ColumnInformation> columnInformation) throws IOException {
        this.columns = new ArrayList<ValueObject>(columnInformation.size());
        Reader reader = new Reader(rawPacket);
        for (ColumnInformation currentColumn : columnInformation) {
            DrizzleValueObject dvo = new DrizzleValueObject(reader.getLengthEncodedBytes(), currentColumn.getType());
            this.columns.add(dvo);
            currentColumn.updateDisplaySize(dvo.getDisplayLength());
        }
    }

    public List<ValueObject> getRow() {
        return this.columns;
    }
}

