/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common.query.parameters;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.drizzle.jdbc.internal.common.Utils;
import org.drizzle.jdbc.internal.common.query.parameters.ParameterHolder;

public class SerializableParameter
implements ParameterHolder {
    private final byte[] rawBytes;
    private final int length;

    public SerializableParameter(Object object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        this.rawBytes = SerializableParameter.escapeBytes(baos.toByteArray());
        this.length = this.rawBytes.length;
    }

    public int writeTo(OutputStream os, int offset, int maxWriteSize) throws IOException {
        int bytesToWrite = Math.min(this.length - offset, maxWriteSize);
        os.write(this.rawBytes, offset, bytesToWrite);
        return bytesToWrite;
    }

    public long length() {
        return this.length;
    }

    private static byte[] escapeBytes(byte[] input) {
        byte[] buffer = new byte[input.length * 2 + 2];
        int i = 0;
        buffer[i++] = 34;
        for (byte b : input) {
            if (Utils.needsEscaping(b)) {
                buffer[i++] = 92;
            }
            buffer[i++] = b;
        }
        buffer[i++] = 34;
        return Utils.copyWithLength(buffer, i);
    }
}

