/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common.query.parameters;

import java.io.IOException;
import java.io.OutputStream;
import org.drizzle.jdbc.internal.common.query.parameters.ParameterHolder;

public class LongParameter
implements ParameterHolder {
    private final byte[] byteRepresentation;

    public LongParameter(long theLong) {
        this.byteRepresentation = String.valueOf(theLong).getBytes();
    }

    public int writeTo(OutputStream os, int offset, int maxWriteSize) throws IOException {
        int bytesToWrite = Math.min(this.byteRepresentation.length - offset, maxWriteSize);
        os.write(this.byteRepresentation, offset, bytesToWrite);
        return bytesToWrite;
    }

    public long length() {
        return this.byteRepresentation.length;
    }
}

