/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common.query.parameters;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import org.drizzle.jdbc.internal.common.query.parameters.ParameterHolder;

public class BigDecimalParameter
implements ParameterHolder {
    private final byte[] rawBytes;

    public BigDecimalParameter(BigDecimal x) {
        this.rawBytes = x.toPlainString().getBytes();
    }

    public int writeTo(OutputStream os, int offset, int maxWriteSize) throws IOException {
        int bytesToWrite = Math.min(this.rawBytes.length - offset, maxWriteSize);
        os.write(this.rawBytes, offset, bytesToWrite);
        return bytesToWrite;
    }

    public long length() {
        return this.rawBytes.length;
    }
}

