/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common.packet;

import java.io.IOException;
import org.drizzle.jdbc.internal.common.packet.EOFPacket;
import org.drizzle.jdbc.internal.common.packet.ErrorPacket;
import org.drizzle.jdbc.internal.common.packet.OKPacket;
import org.drizzle.jdbc.internal.common.packet.RawPacket;
import org.drizzle.jdbc.internal.common.packet.ResultPacket;
import org.drizzle.jdbc.internal.common.packet.ResultSetPacket;

public class ResultPacketFactory {
    private static final byte ERROR = -1;
    private static final byte OK = 0;
    private static final byte EOF = -2;

    private ResultPacketFactory() {
    }

    public static ResultPacket createResultPacket(RawPacket rawPacket) throws IOException {
        byte b = rawPacket.getByteBuffer().get(0);
        switch (b) {
            case -1: {
                return new ErrorPacket(rawPacket);
            }
            case 0: {
                return new OKPacket(rawPacket);
            }
            case -2: {
                return new EOFPacket(rawPacket);
            }
        }
        return new ResultSetPacket(rawPacket);
    }
}

