/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.drizzle.jdbc.internal.common.DataType;
import org.drizzle.jdbc.internal.common.HttpClient;
import org.drizzle.jdbc.internal.common.Protocol;
import org.drizzle.jdbc.internal.common.QueryException;
import org.drizzle.jdbc.internal.common.Utils;
import org.drizzle.jdbc.internal.common.ValueObject;

public abstract class AbstractValueObject
implements ValueObject {
    private final byte[] rawBytes;
    protected final DataType dataType;

    protected AbstractValueObject(byte[] rawBytes, DataType dataType) {
        this.dataType = dataType;
        this.rawBytes = rawBytes;
    }

    public String getString() {
        if (this.rawBytes == null) {
            return null;
        }
        try {
            return new String(this.rawBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported encoding: " + e.getMessage(), e);
        }
    }

    public long getLong() {
        if (this.rawBytes == null) {
            return 0L;
        }
        return Utils.byteArrayToLong(this.rawBytes);
    }

    public int getInt() {
        if (this.rawBytes == null) {
            return 0;
        }
        return Utils.byteArrayToInt(this.rawBytes);
    }

    public short getShort() {
        if (this.rawBytes == null) {
            return 0;
        }
        return Utils.byteArrayToShort(this.rawBytes);
    }

    public byte getByte() {
        if (this.rawBytes == null) {
            return 0;
        }
        switch (this.dataType.getType()) {
            case BIT: {
                return this.rawBytes[0];
            }
        }
        return Utils.byteArrayToByte(this.rawBytes);
    }

    public byte[] getBytes() {
        return this.rawBytes;
    }

    public float getFloat() {
        if (this.rawBytes == null) {
            return 0.0f;
        }
        return Float.valueOf(this.getString()).floatValue();
    }

    public double getDouble() {
        if (this.rawBytes == null) {
            return 0.0;
        }
        return Double.valueOf(this.getString());
    }

    public BigDecimal getBigDecimal() {
        if (this.rawBytes == null) {
            return null;
        }
        return new BigDecimal(this.getString());
    }

    public BigInteger getBigInteger() {
        if (this.rawBytes == null) {
            return null;
        }
        return new BigInteger(this.getString());
    }

    public Date getDate() throws ParseException {
        if (this.rawBytes == null) {
            return null;
        }
        String rawValue = this.getString();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        java.util.Date utilDate = sdf.parse(rawValue);
        return new Date(utilDate.getTime());
    }

    public Time getTime() throws ParseException {
        if (this.rawBytes == null) {
            return null;
        }
        String rawValue = this.getString();
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        sdf.setLenient(false);
        java.util.Date utilTime = sdf.parse(rawValue);
        return new Time(utilTime.getTime());
    }

    public Timestamp getTimestamp() throws ParseException {
        if (this.rawBytes == null) {
            return null;
        }
        String rawValue = this.getString();
        SimpleDateFormat sdf = rawValue.length() > 11 ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss") : new SimpleDateFormat("yyyy-MM-dd");
        sdf.setLenient(false);
        java.util.Date utilTime = sdf.parse(rawValue);
        return new Timestamp(utilTime.getTime());
    }

    public InputStream getInputStream() {
        if (this.rawBytes == null) {
            return null;
        }
        return new ByteArrayInputStream(this.getString().getBytes());
    }

    public InputStream getBinaryInputStream() {
        if (this.rawBytes == null) {
            return null;
        }
        return new ByteArrayInputStream(this.rawBytes);
    }

    public abstract Object getObject() throws ParseException;

    public Date getDate(Calendar cal) throws ParseException {
        if (this.rawBytes == null) {
            return null;
        }
        String rawValue = this.getString();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        sdf.setCalendar(cal);
        java.util.Date utilDate = sdf.parse(rawValue);
        return new Date(utilDate.getTime());
    }

    public Time getTime(Calendar cal) {
        if (this.rawBytes == null) {
            return null;
        }
        int packedTime = this.getInt();
        long millis = Utils.unpackTime(packedTime);
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        sdf.setCalendar(cal);
        return new Time(millis);
    }

    public Timestamp getTimestamp(Calendar cal) throws ParseException {
        if (this.rawBytes == null) {
            return null;
        }
        String rawValue = this.getString();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setCalendar(cal);
        java.util.Date utilTime = sdf.parse(rawValue);
        return new Timestamp(utilTime.getTime());
    }

    public boolean getBoolean() {
        if (this.rawBytes == null) {
            return false;
        }
        String rawVal = this.getString();
        return rawVal.equalsIgnoreCase("true") || rawVal.equalsIgnoreCase("1") || (this.rawBytes[0] & 1) == 1;
    }

    public boolean isNull() {
        return this.rawBytes == null;
    }

    public int getDisplayLength() {
        if (this.rawBytes != null) {
            return this.rawBytes.length;
        }
        return 4;
    }

    public InputStream getPBMSStream(Protocol protocol) throws QueryException, IOException {
        if (this.rawBytes == null) {
            return null;
        }
        if (this.rawBytes[0] == 126 && this.rawBytes[1] == 42) {
            String port = protocol.getServerVariable("pbms_port");
            HttpClient httpClient = new HttpClient("http://" + protocol.getHost() + ":" + port + "/" + this.getString());
            return httpClient.get();
        }
        return this.getBinaryInputStream();
    }
}

