/*
 * Drizzle-JDBC
 *
 * Copyright (c) 2009-2011, Marcus Eriksson
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following
 * conditions are met:
 *
 *  Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
 *  Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following
 *   disclaimer in the documentation and/or other materials provided with the distribution.
 *  Neither the name of the driver nor the names of its contributors may be used to endorse or promote products derived
 *   from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.drizzle.jdbc.internal.common.query;

/**
 * Created by IntelliJ IDEA. User: marcuse Date: Aug 13, 2009 Time: 8:58:08 PM To change this template use File |
 * Settings | File Templates.
 */
public enum QueryType {
    REPLACE, INSERT, SELECT, UPDATE, DELETE, ALTER, UNCLASSIFIABLE;

    public static QueryType classifyQuery(final String query) {
        final String lowerCaseQuery = query.toLowerCase();
        if (lowerCaseQuery.startsWith("select")) {
            return QueryType.SELECT;
        } else if (lowerCaseQuery.startsWith("update")) {
            return QueryType.UPDATE;
        } else if (lowerCaseQuery.startsWith("insert")) {
            return QueryType.INSERT;
        } else if (lowerCaseQuery.startsWith("alter")) {
            return QueryType.ALTER;
        } else if (lowerCaseQuery.startsWith("delete")) {
            return QueryType.DELETE;
        } else if (lowerCaseQuery.startsWith("replace")) {
            return QueryType.REPLACE;
        } else {
            return QueryType.UNCLASSIFIABLE;
        }
    }
}
