/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.shared.cldr.impl;

import org.gwtproject.i18n.shared.cldr.LocalizedNamesImplBase;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "tt" locale.
 */
public class LocalizedNamesImpl_tt extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "BQ",
        "CD",
        "CG",
        "CP",
        "DG",
        "EA",
        "EH",
        "EU",
        "EZ",
        "IC",
        "KR",
        "MK",
        "MM",
        "PS",
        "QO",
        "SH",
        "TA",
        "UN",
        "VA",
        "XA",
        "XB",
        "US",
        "VI",
        "UM",
        "AU",
        "AT",
        "AX",
        "AL",
        "DZ",
        "AS",
        "AI",
        "AO",
        "AD",
        "AQ",
        "AG",
        "AR",
        "AW",
        "BS",
        "BD",
        "BB",
        "BY",
        "BZ",
        "BE",
        "BJ",
        "AE",
        "BM",
        "BG",
        "BO",
        "BA",
        "BW",
        "BR",
        "VG",
        "IO",
        "BN",
        "BV",
        "BF",
        "BI",
        "BT",
        "BH",
        "GB",
        "VU",
        "HU",
        "VE",
        "VN",
        "GA",
        "HT",
        "GY",
        "GM",
        "GH",
        "GP",
        "GT",
        "GN",
        "GW",
        "DE",
        "GG",
        "GI",
        "HN",
        "HK",
        "GD",
        "GL",
        "GR",
        "GE",
        "GU",
        "IQ",
        "DK",
        "JE",
        "DM",
        "DO",
        "ZM",
        "ZW",
        "IL",
        "IN",
        "ID",
        "JO",
        "IR",
        "IE",
        "IS",
        "ES",
        "IT",
        "YE",
        "CV",
        "KZ",
        "KY",
        "KH",
        "CM",
        "CA",
        "QA",
        "KE",
        "CY",
        "KI",
        "CC",
        "CO",
        "KM",
        "XK",
        "CR",
        "CI",
        "CU",
        "CK",
        "KG",
        "CN",
        "CW",
        "KW",
        "ZA",
        "GS",
        "SS",
        "LA",
        "LV",
        "LS",
        "LR",
        "LB",
        "LY",
        "LT",
        "LI",
        "LU",
        "MU",
        "MR",
        "MG",
        "YT",
        "MO",
        "MW",
        "MY",
        "ML",
        "MV",
        "MT",
        "MA",
        "MQ",
        "MH",
        "MX",
        "FM",
        "EG",
        "MZ",
        "MD",
        "MC",
        "MN",
        "MS",
        "IM",
        "NA",
        "NR",
        "NP",
        "NE",
        "NG",
        "NL",
        "NI",
        "NU",
        "NO",
        "NF",
        "OM",
        "PK",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PL",
        "PT",
        "PR",
        "CX",
        "RE",
        "RU",
        "RW",
        "RO",
        "SV",
        "WS",
        "SM",
        "ST",
        "SZ",
        "SC",
        "BL",
        "PM",
        "SN",
        "VC",
        "KN",
        "LC",
        "MF",
        "RS",
        "SG",
        "SX",
        "SK",
        "SI",
        "SA",
        "SO",
        "SD",
        "SR",
        "SL",
        "SY",
        "SB",
        "TW",
        "TH",
        "TZ",
        "TJ",
        "TC",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TV",
        "TN",
        "KP",
        "MP",
        "TR",
        "TM",
        "UG",
        "UA",
        "WF",
        "UY",
        "FO",
        "FJ",
        "PH",
        "FI",
        "FK",
        "FR",
        "TF",
        "GF",
        "PF",
        "HM",
        "HR",
        "TD",
        "ME",
        "CZ",
        "CL",
        "CH",
        "SE",
        "SJ",
        "LK",
        "EC",
        "GQ",
        "ER",
        "EE",
        "ET",
        "JM",
        "JP",
        "NZ",
        "NC",
        "DJ",
        "UZ",
        "CF",
        "AZ",
        "AM",
        "AF",
    };
  }

  @Override
  protected void loadNameMap() {
    super.loadNameMap();
    namesMap.put("AD", "Андорра");
    namesMap.put("AE", "Берләшкән Гарәп Әмирлекләре");
    namesMap.put("AF", "Әфганстан");
    namesMap.put("AG", "Антигуа һәм Барбуда");
    namesMap.put("AI", "Ангилья");
    namesMap.put("AL", "Албания");
    namesMap.put("AM", "Әрмәнстан");
    namesMap.put("AO", "Ангола");
    namesMap.put("AQ", "Антарктика");
    namesMap.put("AR", "Аргентина");
    namesMap.put("AS", "Америка Самоасы");
    namesMap.put("AT", "Австрия");
    namesMap.put("AU", "Австралия");
    namesMap.put("AW", "Аруба");
    namesMap.put("AX", "Аланд утраулары");
    namesMap.put("AZ", "Әзәрбайҗан");
    namesMap.put("BA", "Босния һәм Герцеговина");
    namesMap.put("BB", "Барбадос");
    namesMap.put("BD", "Бангладеш");
    namesMap.put("BE", "Бельгия");
    namesMap.put("BF", "Буркина-Фасо");
    namesMap.put("BG", "Болгария");
    namesMap.put("BH", "Бәхрәйн");
    namesMap.put("BI", "Бурунди");
    namesMap.put("BJ", "Бенин");
    namesMap.put("BL", "Сен-Бартельми");
    namesMap.put("BM", "Бермуд утраулары");
    namesMap.put("BN", "Бруней");
    namesMap.put("BO", "Боливия");
    namesMap.put("BR", "Бразилия");
    namesMap.put("BS", "Багам утраулары");
    namesMap.put("BT", "Бутан");
    namesMap.put("BV", "Буве утравы");
    namesMap.put("BW", "Ботсвана");
    namesMap.put("BY", "Беларусь");
    namesMap.put("BZ", "Белиз");
    namesMap.put("CA", "Канада");
    namesMap.put("CC", "Кокос (Килинг) утраулары");
    namesMap.put("CF", "Үзәк Африка Республикасы");
    namesMap.put("CH", "Швейцария");
    namesMap.put("CI", "Кот-д’Ивуар");
    namesMap.put("CK", "Кук утраулары");
    namesMap.put("CL", "Чили");
    namesMap.put("CM", "Камерун");
    namesMap.put("CN", "Кытай");
    namesMap.put("CO", "Колумбия");
    namesMap.put("CR", "Коста-Рика");
    namesMap.put("CU", "Куба");
    namesMap.put("CV", "Кабо-Верде");
    namesMap.put("CW", "Кюрасао");
    namesMap.put("CX", "Раштуа утравы");
    namesMap.put("CY", "Кипр");
    namesMap.put("CZ", "Чехия Республикасы");
    namesMap.put("DE", "Германия");
    namesMap.put("DJ", "Җибүти");
    namesMap.put("DK", "Дания");
    namesMap.put("DM", "Доминика");
    namesMap.put("DO", "Доминикана Республикасы");
    namesMap.put("DZ", "Алжир");
    namesMap.put("EC", "Эквадор");
    namesMap.put("EE", "Эстония");
    namesMap.put("EG", "Мисыр");
    namesMap.put("ER", "Эритрея");
    namesMap.put("ES", "Испания");
    namesMap.put("ET", "Эфиопия");
    namesMap.put("FI", "Финляндия");
    namesMap.put("FJ", "Фиджи");
    namesMap.put("FK", "Фолкленд утраулары");
    namesMap.put("FM", "Микронезия");
    namesMap.put("FO", "Фарер утраулары");
    namesMap.put("FR", "Франция");
    namesMap.put("GA", "Габон");
    namesMap.put("GB", "Бөекбритания");
    namesMap.put("GD", "Гренада");
    namesMap.put("GE", "Грузия");
    namesMap.put("GF", "Француз Гвианасы");
    namesMap.put("GG", "Гернси");
    namesMap.put("GH", "Гана");
    namesMap.put("GI", "Гибралтар");
    namesMap.put("GL", "Гренландия");
    namesMap.put("GM", "Гамбия");
    namesMap.put("GN", "Гвинея");
    namesMap.put("GP", "Гваделупа");
    namesMap.put("GQ", "Экваториаль Гвинея");
    namesMap.put("GR", "Греция");
    namesMap.put("GS", "Көньяк Георгия һәм Көньяк Сандвич утраулары");
    namesMap.put("GT", "Гватемала");
    namesMap.put("GU", "Гуам");
    namesMap.put("GW", "Гвинея-Бисау");
    namesMap.put("GY", "Гайана");
    namesMap.put("HK", "Гонконг Махсус Идарәле Төбәге");
    namesMap.put("HM", "Херд утравы һәм Макдональд утраулары");
    namesMap.put("HN", "Гондурас");
    namesMap.put("HR", "Хорватия");
    namesMap.put("HT", "Гаити");
    namesMap.put("HU", "Венгрия");
    namesMap.put("ID", "Индонезия");
    namesMap.put("IE", "Ирландия");
    namesMap.put("IL", "Израиль");
    namesMap.put("IM", "Мэн утравы");
    namesMap.put("IN", "Индия");
    namesMap.put("IO", "Британиянең Һинд Океанындагы Территориясе");
    namesMap.put("IQ", "Гыйрак");
    namesMap.put("IR", "Иран");
    namesMap.put("IS", "Исландия");
    namesMap.put("IT", "Италия");
    namesMap.put("JE", "Джерси");
    namesMap.put("JM", "Ямайка");
    namesMap.put("JO", "Иордания");
    namesMap.put("JP", "Япония");
    namesMap.put("KE", "Кения");
    namesMap.put("KG", "Кыргызстан");
    namesMap.put("KH", "Камбоджа");
    namesMap.put("KI", "Кирибати");
    namesMap.put("KM", "Комор утраулары");
    namesMap.put("KN", "Сент-Китс һәм Невис");
    namesMap.put("KP", "Төньяк Корея");
    namesMap.put("KW", "Күвәйт");
    namesMap.put("KY", "Кайман утраулары");
    namesMap.put("KZ", "Казахстан");
    namesMap.put("LA", "Лаос");
    namesMap.put("LB", "Ливан");
    namesMap.put("LC", "Сент-Люсия");
    namesMap.put("LI", "Лихтенштейн");
    namesMap.put("LK", "Шри-Ланка");
    namesMap.put("LR", "Либерия");
    namesMap.put("LS", "Лесото");
    namesMap.put("LT", "Литва");
    namesMap.put("LU", "Люксембург");
    namesMap.put("LV", "Латвия");
    namesMap.put("LY", "Ливия");
    namesMap.put("MA", "Марокко");
    namesMap.put("MC", "Монако");
    namesMap.put("MD", "Молдова");
    namesMap.put("ME", "Черногория");
    namesMap.put("MF", "Сент-Мартин");
    namesMap.put("MG", "Мадагаскар");
    namesMap.put("MH", "Маршалл утраулары");
    namesMap.put("ML", "Мали");
    namesMap.put("MN", "Монголия");
    namesMap.put("MO", "Макао Махсус Идарәле Төбәге");
    namesMap.put("MP", "Төньяк Мариана утраулары");
    namesMap.put("MQ", "Мартиника");
    namesMap.put("MR", "Мавритания");
    namesMap.put("MS", "Монтсеррат");
    namesMap.put("MT", "Мальта");
    namesMap.put("MU", "Маврикий");
    namesMap.put("MV", "Мальдив утраулары");
    namesMap.put("MW", "Малави");
    namesMap.put("MX", "Мексика");
    namesMap.put("MY", "Малайзия");
    namesMap.put("MZ", "Мозамбик");
    namesMap.put("NA", "Намибия");
    namesMap.put("NC", "Яңа Каледония");
    namesMap.put("NE", "Нигер");
    namesMap.put("NF", "Норфолк утравы");
    namesMap.put("NG", "Нигерия");
    namesMap.put("NI", "Никарагуа");
    namesMap.put("NL", "Нидерланд");
    namesMap.put("NO", "Норвегия");
    namesMap.put("NP", "Непал");
    namesMap.put("NR", "Науру");
    namesMap.put("NU", "Ниуэ");
    namesMap.put("NZ", "Яңа Зеландия");
    namesMap.put("OM", "Оман");
    namesMap.put("PA", "Панама");
    namesMap.put("PE", "Перу");
    namesMap.put("PF", "Француз Полинезиясе");
    namesMap.put("PG", "Папуа - Яңа Гвинея");
    namesMap.put("PH", "Филиппин");
    namesMap.put("PK", "Пакистан");
    namesMap.put("PL", "Польша");
    namesMap.put("PM", "Сен-Пьер һәм Микелон");
    namesMap.put("PN", "Питкэрн утраулары");
    namesMap.put("PR", "Пуэрто-Рико");
    namesMap.put("PT", "Португалия");
    namesMap.put("PW", "Палау");
    namesMap.put("PY", "Парагвай");
    namesMap.put("QA", "Катар");
    namesMap.put("RE", "Реюньон");
    namesMap.put("RO", "Румыния");
    namesMap.put("RS", "Сербия");
    namesMap.put("RU", "Россия");
    namesMap.put("RW", "Руанда");
    namesMap.put("SA", "Согуд Гарәбстаны");
    namesMap.put("SB", "Сөләйман утраулары");
    namesMap.put("SC", "Сейшел утраулары");
    namesMap.put("SD", "Судан");
    namesMap.put("SE", "Швеция");
    namesMap.put("SG", "Сингапур");
    namesMap.put("SI", "Словения");
    namesMap.put("SJ", "Шпицберген һәм Ян-Майен");
    namesMap.put("SK", "Словакия");
    namesMap.put("SL", "Сьерра-Леоне");
    namesMap.put("SM", "Сан-Марино");
    namesMap.put("SN", "Сенегал");
    namesMap.put("SO", "Сомали");
    namesMap.put("SR", "Суринам");
    namesMap.put("SS", "Көньяк Судан");
    namesMap.put("ST", "Сан-Томе һәм Принсипи");
    namesMap.put("SV", "Сальвадор");
    namesMap.put("SX", "Синт-Мартен");
    namesMap.put("SY", "Сүрия");
    namesMap.put("SZ", "Свазиленд");
    namesMap.put("TC", "Теркс һәм Кайкос утраулары");
    namesMap.put("TD", "Чад");
    namesMap.put("TF", "Франциянең Көньяк Территорияләре");
    namesMap.put("TG", "Того");
    namesMap.put("TH", "Тайланд");
    namesMap.put("TJ", "Таҗикстан");
    namesMap.put("TK", "Токелау");
    namesMap.put("TL", "Тимор-Лесте");
    namesMap.put("TM", "Төркмәнстан");
    namesMap.put("TN", "Тунис");
    namesMap.put("TO", "Тонга");
    namesMap.put("TR", "Төркия");
    namesMap.put("TT", "Тринидад һәм Тобаго");
    namesMap.put("TV", "Тувалу");
    namesMap.put("TW", "Тайвань");
    namesMap.put("TZ", "Танзания");
    namesMap.put("UA", "Украина");
    namesMap.put("UG", "Уганда");
    namesMap.put("UM", "АКШ Кече Читтәге утраулары");
    namesMap.put("US", "АКШ");
    namesMap.put("UY", "Уругвай");
    namesMap.put("UZ", "Үзбәкстан");
    namesMap.put("VC", "Сент-Винсент һәм Гренадин");
    namesMap.put("VE", "Венесуэла");
    namesMap.put("VG", "Британия Виргин утраулары");
    namesMap.put("VI", "АКШ Виргин утраулары");
    namesMap.put("VN", "Вьетнам");
    namesMap.put("VU", "Вануату");
    namesMap.put("WF", "Уоллис һәм Футуна");
    namesMap.put("WS", "Самоа");
    namesMap.put("XK", "Косово");
    namesMap.put("YE", "Йәмән");
    namesMap.put("YT", "Майотта");
    namesMap.put("ZA", "Көньяк Африка");
    namesMap.put("ZM", "Замбия");
    namesMap.put("ZW", "Зимбабве");
    namesMap.put("ZZ", "билгесез төбәк");
  }

}
