/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.shared.cldr.impl;

import org.gwtproject.i18n.shared.cldr.LocalizedNamesImplBase;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "hi" locale.
 */
public class LocalizedNamesImpl_hi extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "IN",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "XA",
        "XB",
        "AO",
        "AQ",
        "AZ",
        "AF",
        "AS",
        "AW",
        "AR",
        "SV",
        "DZ",
        "AL",
        "AC",
        "IM",
        "IS",
        "QO",
        "IE",
        "AM",
        "ID",
        "EC",
        "GQ",
        "IL",
        "IT",
        "ET",
        "IQ",
        "ER",
        "IR",
        "UZ",
        "KP",
        "MP",
        "UY",
        "AI",
        "AG",
        "AD",
        "AX",
        "EE",
        "OM",
        "AT",
        "AU",
        "KH",
        "KZ",
        "CA",
        "CD",
        "CG",
        "KI",
        "KG",
        "CK",
        "KW",
        "KE",
        "CV",
        "IC",
        "CM",
        "KY",
        "BQ",
        "CC",
        "CI",
        "KM",
        "CO",
        "XK",
        "CR",
        "CU",
        "CW",
        "CX",
        "HR",
        "CP",
        "QA",
        "GG",
        "GM",
        "GN",
        "GW",
        "GU",
        "GY",
        "GA",
        "GL",
        "GD",
        "GT",
        "GP",
        "GH",
        "TD",
        "CL",
        "CN",
        "CZ",
        "JM",
        "DE",
        "JE",
        "JP",
        "DJ",
        "GI",
        "GE",
        "JO",
        "ZM",
        "ZW",
        "TO",
        "TG",
        "TN",
        "TA",
        "DG",
        "DK",
        "DO",
        "DM",
        "TZ",
        "TW",
        "TJ",
        "TL",
        "TC",
        "TM",
        "TR",
        "TV",
        "TK",
        "TT",
        "TH",
        "ZA",
        "KR",
        "GS",
        "SS",
        "NE",
        "NG",
        "NR",
        "NA",
        "NI",
        "NL",
        "NU",
        "NP",
        "NF",
        "NO",
        "NC",
        "NZ",
        "PA",
        "PY",
        "PW",
        "EH",
        "PK",
        "PG",
        "PN",
        "PT",
        "PE",
        "PR",
        "PL",
        "FJ",
        "FI",
        "PH",
        "PS",
        "FO",
        "FK",
        "FR",
        "TF",
        "GF",
        "PF",
        "BM",
        "BH",
        "BS",
        "BD",
        "BB",
        "BI",
        "BF",
        "BG",
        "BJ",
        "BY",
        "BZ",
        "BE",
        "BW",
        "BO",
        "BV",
        "BA",
        "BR",
        "VG",
        "IO",
        "BN",
        "IN",
        "BT",
        "MN",
        "MK",
        "MO",
        "CF",
        "MW",
        "MY",
        "FM",
        "YT",
        "MQ",
        "MH",
        "MV",
        "ML",
        "MT",
        "EG",
        "MG",
        "MX",
        "MS",
        "ME",
        "MZ",
        "MC",
        "MA",
        "MR",
        "MU",
        "MD",
        "MM",
        "YE",
        "UG",
        "UA",
        "GB",
        "GR",
        "EZ",
        "EU",
        "UM",
        "VI",
        "RW",
        "RE",
        "RU",
        "RO",
        "LU",
        "LR",
        "LA",
        "LV",
        "LI",
        "LT",
        "LY",
        "LB",
        "LS",
        "VU",
        "WF",
        "VN",
        "VA",
        "VE",
        "LK",
        "AE",
        "US",
        "UN",
        "SA",
        "WS",
        "RS",
        "CY",
        "ST",
        "SG",
        "SX",
        "SL",
        "SY",
        "SD",
        "SR",
        "KN",
        "PM",
        "BL",
        "MF",
        "LC",
        "VC",
        "SH",
        "EA",
        "SN",
        "SC",
        "SM",
        "SO",
        "SB",
        "ES",
        "SK",
        "SI",
        "SZ",
        "SJ",
        "CH",
        "SE",
        "HU",
        "HM",
        "HK",
        "HT",
        "HN",
    };
  }

  @Override
  protected void loadNameMap() {
    super.loadNameMap();
    namesMap.put("001", "विश्व");
    namesMap.put("002", "अफ़्रीका");
    namesMap.put("003", "उत्तर अमेरिका");
    namesMap.put("005", "दक्षिण अमेरिका");
    namesMap.put("009", "ओशिआनिया");
    namesMap.put("011", "पश्चिमी अफ़्रीका");
    namesMap.put("013", "मध्य अमेरिका");
    namesMap.put("014", "पूर्वी अफ़्रीका");
    namesMap.put("015", "उत्तरी अफ़्रीका");
    namesMap.put("017", "मध्य अफ़्रीका");
    namesMap.put("018", "दक्षिणी अफ़्रीका");
    namesMap.put("019", "अमेरिकाज़");
    namesMap.put("021", "उत्तरी अमेरिका");
    namesMap.put("029", "कैरिबियन");
    namesMap.put("030", "पूर्वी एशिया");
    namesMap.put("034", "दक्षिणी एशिया");
    namesMap.put("035", "दक्षिण-पूर्व एशिया");
    namesMap.put("039", "दक्षिणी यूरोप");
    namesMap.put("053", "ऑस्ट्रेलेशिया");
    namesMap.put("054", "मेलानेशिया");
    namesMap.put("057", "माइक्रोनेशियाई क्षेत्र");
    namesMap.put("061", "पोलिनेशिया");
    namesMap.put("142", "एशिया");
    namesMap.put("143", "मध्य एशिया");
    namesMap.put("145", "पश्चिमी एशिया");
    namesMap.put("150", "यूरोप");
    namesMap.put("151", "पूर्वी यूरोप");
    namesMap.put("154", "उत्तरी यूरोप");
    namesMap.put("155", "पश्चिमी यूरोप");
    namesMap.put("202", "उप-सहारा अफ़्रीका");
    namesMap.put("419", "लैटिन अमेरिका");
    namesMap.put("AC", "असेंशन द्वीप");
    namesMap.put("AD", "एंडोरा");
    namesMap.put("AE", "संयुक्त अरब अमीरात");
    namesMap.put("AF", "अफ़गानिस्तान");
    namesMap.put("AG", "एंटिगुआ और बरबुडा");
    namesMap.put("AI", "एंग्विला");
    namesMap.put("AL", "अल्बानिया");
    namesMap.put("AM", "आर्मेनिया");
    namesMap.put("AO", "अंगोला");
    namesMap.put("AQ", "अंटार्कटिका");
    namesMap.put("AR", "अर्जेंटीना");
    namesMap.put("AS", "अमेरिकी समोआ");
    namesMap.put("AT", "ऑस्ट्रिया");
    namesMap.put("AU", "ऑस्ट्रेलिया");
    namesMap.put("AW", "अरूबा");
    namesMap.put("AX", "एलैंड द्वीपसमूह");
    namesMap.put("AZ", "अज़रबैजान");
    namesMap.put("BA", "बोस्निया और हर्ज़ेगोविना");
    namesMap.put("BB", "बारबाडोस");
    namesMap.put("BD", "बांग्लादेश");
    namesMap.put("BE", "बेल्जियम");
    namesMap.put("BF", "बुर्किना फ़ासो");
    namesMap.put("BG", "बुल्गारिया");
    namesMap.put("BH", "बहरीन");
    namesMap.put("BI", "बुरुंडी");
    namesMap.put("BJ", "बेनिन");
    namesMap.put("BL", "सेंट बार्थेलेमी");
    namesMap.put("BM", "बरमूडा");
    namesMap.put("BN", "ब्रूनेई");
    namesMap.put("BO", "बोलीविया");
    namesMap.put("BQ", "कैरिबियन नीदरलैंड");
    namesMap.put("BR", "ब्राज़ील");
    namesMap.put("BS", "बहामास");
    namesMap.put("BT", "भूटान");
    namesMap.put("BV", "बोवेत द्वीप");
    namesMap.put("BW", "बोत्स्वाना");
    namesMap.put("BY", "बेलारूस");
    namesMap.put("BZ", "बेलीज़");
    namesMap.put("CA", "कनाडा");
    namesMap.put("CC", "कोकोस (कीलिंग) द्वीपसमूह");
    namesMap.put("CD", "कांगो - किंशासा");
    namesMap.put("CF", "मध्य अफ़्रीकी गणराज्य");
    namesMap.put("CG", "कांगो – ब्राज़ाविल");
    namesMap.put("CH", "स्विट्ज़रलैंड");
    namesMap.put("CI", "कोट डी आइवर");
    namesMap.put("CK", "कुक द्वीपसमूह");
    namesMap.put("CL", "चिली");
    namesMap.put("CM", "कैमरून");
    namesMap.put("CN", "चीन");
    namesMap.put("CO", "कोलंबिया");
    namesMap.put("CP", "क्लिपर्टन द्वीप");
    namesMap.put("CR", "कोस्टारिका");
    namesMap.put("CU", "क्यूबा");
    namesMap.put("CV", "केप वर्ड");
    namesMap.put("CW", "क्यूरासाओ");
    namesMap.put("CX", "क्रिसमस द्वीप");
    namesMap.put("CY", "साइप्रस");
    namesMap.put("CZ", "चेकिया");
    namesMap.put("DE", "जर्मनी");
    namesMap.put("DG", "डिएगो गार्सिया");
    namesMap.put("DJ", "जिबूती");
    namesMap.put("DK", "डेनमार्क");
    namesMap.put("DM", "डोमिनिका");
    namesMap.put("DO", "डोमिनिकन गणराज्य");
    namesMap.put("DZ", "अल्जीरिया");
    namesMap.put("EA", "सेउटा और मेलिला");
    namesMap.put("EC", "इक्वाडोर");
    namesMap.put("EE", "एस्टोनिया");
    namesMap.put("EG", "मिस्र");
    namesMap.put("EH", "पश्चिमी सहारा");
    namesMap.put("ER", "इरिट्रिया");
    namesMap.put("ES", "स्पेन");
    namesMap.put("ET", "इथियोपिया");
    namesMap.put("EU", "यूरोपीय संघ");
    namesMap.put("EZ", "यूरोज़ोन");
    namesMap.put("FI", "फ़िनलैंड");
    namesMap.put("FJ", "फ़िजी");
    namesMap.put("FK", "फ़ॉकलैंड द्वीपसमूह");
    namesMap.put("FM", "माइक्रोनेशिया");
    namesMap.put("FO", "फ़ेरो द्वीपसमूह");
    namesMap.put("FR", "फ़्रांस");
    namesMap.put("GA", "गैबॉन");
    namesMap.put("GB", "यूनाइटेड किंगडम");
    namesMap.put("GD", "ग्रेनाडा");
    namesMap.put("GE", "जॉर्जिया");
    namesMap.put("GF", "फ़्रेंच गुयाना");
    namesMap.put("GG", "गर्नसी");
    namesMap.put("GH", "घाना");
    namesMap.put("GI", "जिब्राल्टर");
    namesMap.put("GL", "ग्रीनलैंड");
    namesMap.put("GM", "गाम्बिया");
    namesMap.put("GN", "गिनी");
    namesMap.put("GP", "ग्वाडेलूप");
    namesMap.put("GQ", "इक्वेटोरियल गिनी");
    namesMap.put("GR", "यूनान");
    namesMap.put("GS", "दक्षिण जॉर्जिया और दक्षिण सैंडविच द्वीपसमूह");
    namesMap.put("GT", "ग्वाटेमाला");
    namesMap.put("GU", "गुआम");
    namesMap.put("GW", "गिनी-बिसाउ");
    namesMap.put("GY", "गुयाना");
    namesMap.put("HK", "हाँग काँग (चीन विशेष प्रशासनिक क्षेत्र)");
    namesMap.put("HM", "हर्ड द्वीप और मैकडोनॉल्ड द्वीपसमूह");
    namesMap.put("HN", "होंडूरास");
    namesMap.put("HR", "क्रोएशिया");
    namesMap.put("HT", "हैती");
    namesMap.put("HU", "हंगरी");
    namesMap.put("IC", "कैनेरी द्वीपसमूह");
    namesMap.put("ID", "इंडोनेशिया");
    namesMap.put("IE", "आयरलैंड");
    namesMap.put("IL", "इज़राइल");
    namesMap.put("IM", "आइल ऑफ़ मैन");
    namesMap.put("IN", "भारत");
    namesMap.put("IO", "ब्रिटिश हिंद महासागरीय क्षेत्र");
    namesMap.put("IQ", "इराक");
    namesMap.put("IR", "ईरान");
    namesMap.put("IS", "आइसलैंड");
    namesMap.put("IT", "इटली");
    namesMap.put("JE", "जर्सी");
    namesMap.put("JM", "जमैका");
    namesMap.put("JO", "जॉर्डन");
    namesMap.put("JP", "जापान");
    namesMap.put("KE", "केन्या");
    namesMap.put("KG", "किर्गिज़स्तान");
    namesMap.put("KH", "कंबोडिया");
    namesMap.put("KI", "किरिबाती");
    namesMap.put("KM", "कोमोरोस");
    namesMap.put("KN", "सेंट किट्स और नेविस");
    namesMap.put("KP", "उत्तर कोरिया");
    namesMap.put("KR", "दक्षिण कोरिया");
    namesMap.put("KW", "कुवैत");
    namesMap.put("KY", "कैमेन द्वीपसमूह");
    namesMap.put("KZ", "कज़ाखस्तान");
    namesMap.put("LA", "लाओस");
    namesMap.put("LB", "लेबनान");
    namesMap.put("LC", "सेंट लूसिया");
    namesMap.put("LI", "लिचेंस्टीन");
    namesMap.put("LK", "श्रीलंका");
    namesMap.put("LR", "लाइबेरिया");
    namesMap.put("LS", "लेसोथो");
    namesMap.put("LT", "लिथुआनिया");
    namesMap.put("LU", "लग्ज़मबर्ग");
    namesMap.put("LV", "लातविया");
    namesMap.put("LY", "लीबिया");
    namesMap.put("MA", "मोरक्को");
    namesMap.put("MC", "मोनाको");
    namesMap.put("MD", "मॉल्डोवा");
    namesMap.put("ME", "मोंटेनेग्रो");
    namesMap.put("MF", "सेंट मार्टिन");
    namesMap.put("MG", "मेडागास्कर");
    namesMap.put("MH", "मार्शल द्वीपसमूह");
    namesMap.put("MK", "मकदूनिया");
    namesMap.put("ML", "माली");
    namesMap.put("MM", "म्यांमार (बर्मा)");
    namesMap.put("MN", "मंगोलिया");
    namesMap.put("MO", "मकाऊ (विशेष प्रशासनिक क्षेत्र चीन)");
    namesMap.put("MP", "उत्तरी मारियाना द्वीपसमूह");
    namesMap.put("MQ", "मार्टीनिक");
    namesMap.put("MR", "मॉरिटानिया");
    namesMap.put("MS", "मोंटसेरात");
    namesMap.put("MT", "माल्टा");
    namesMap.put("MU", "मॉरीशस");
    namesMap.put("MV", "मालदीव");
    namesMap.put("MW", "मलावी");
    namesMap.put("MX", "मैक्सिको");
    namesMap.put("MY", "मलेशिया");
    namesMap.put("MZ", "मोज़ांबिक");
    namesMap.put("NA", "नामीबिया");
    namesMap.put("NC", "न्यू कैलेडोनिया");
    namesMap.put("NE", "नाइजर");
    namesMap.put("NF", "नॉरफ़ॉक द्वीप");
    namesMap.put("NG", "नाइजीरिया");
    namesMap.put("NI", "निकारागुआ");
    namesMap.put("NL", "नीदरलैंड");
    namesMap.put("NO", "नॉर्वे");
    namesMap.put("NP", "नेपाल");
    namesMap.put("NR", "नाउरु");
    namesMap.put("NU", "नीयू");
    namesMap.put("NZ", "न्यूज़ीलैंड");
    namesMap.put("OM", "ओमान");
    namesMap.put("PA", "पनामा");
    namesMap.put("PE", "पेरू");
    namesMap.put("PF", "फ़्रेंच पोलिनेशिया");
    namesMap.put("PG", "पापुआ न्यू गिनी");
    namesMap.put("PH", "फ़िलिपींस");
    namesMap.put("PK", "पाकिस्तान");
    namesMap.put("PL", "पोलैंड");
    namesMap.put("PM", "सेंट पिएरे और मिक्वेलान");
    namesMap.put("PN", "पिटकैर्न द्वीपसमूह");
    namesMap.put("PR", "पोर्टो रिको");
    namesMap.put("PS", "फ़िलिस्तीनी क्षेत्र");
    namesMap.put("PT", "पुर्तगाल");
    namesMap.put("PW", "पलाऊ");
    namesMap.put("PY", "पराग्वे");
    namesMap.put("QA", "क़तर");
    namesMap.put("QO", "आउटलाइंग ओशिनिया");
    namesMap.put("RE", "रियूनियन");
    namesMap.put("RO", "रोमानिया");
    namesMap.put("RS", "सर्बिया");
    namesMap.put("RU", "रूस");
    namesMap.put("RW", "रवांडा");
    namesMap.put("SA", "सऊदी अरब");
    namesMap.put("SB", "सोलोमन द्वीपसमूह");
    namesMap.put("SC", "सेशेल्स");
    namesMap.put("SD", "सूडान");
    namesMap.put("SE", "स्वीडन");
    namesMap.put("SG", "सिंगापुर");
    namesMap.put("SH", "सेंट हेलेना");
    namesMap.put("SI", "स्लोवेनिया");
    namesMap.put("SJ", "स्वालबार्ड और जान मायेन");
    namesMap.put("SK", "स्लोवाकिया");
    namesMap.put("SL", "सिएरा लियोन");
    namesMap.put("SM", "सैन मेरीनो");
    namesMap.put("SN", "सेनेगल");
    namesMap.put("SO", "सोमालिया");
    namesMap.put("SR", "सूरीनाम");
    namesMap.put("SS", "दक्षिण सूडान");
    namesMap.put("ST", "साओ टोम और प्रिंसिपे");
    namesMap.put("SV", "अल सल्वाडोर");
    namesMap.put("SX", "सिंट मार्टिन");
    namesMap.put("SY", "सीरिया");
    namesMap.put("SZ", "स्वाज़ीलैंड");
    namesMap.put("TA", "ट्रिस्टन दा कुना");
    namesMap.put("TC", "तुर्क और कैकोज़ द्वीपसमूह");
    namesMap.put("TD", "चाड");
    namesMap.put("TF", "फ़्रांसीसी दक्षिणी क्षेत्र");
    namesMap.put("TG", "टोगो");
    namesMap.put("TH", "थाईलैंड");
    namesMap.put("TJ", "ताज़िकिस्तान");
    namesMap.put("TK", "तोकेलाउ");
    namesMap.put("TL", "तिमोर-लेस्त");
    namesMap.put("TM", "तुर्कमेनिस्तान");
    namesMap.put("TN", "ट्यूनीशिया");
    namesMap.put("TO", "टोंगा");
    namesMap.put("TR", "तुर्की");
    namesMap.put("TT", "त्रिनिदाद और टोबैगो");
    namesMap.put("TV", "तुवालू");
    namesMap.put("TW", "ताइवान");
    namesMap.put("TZ", "तंज़ानिया");
    namesMap.put("UA", "यूक्रेन");
    namesMap.put("UG", "युगांडा");
    namesMap.put("UM", "यू॰एस॰ आउटलाइंग द्वीपसमूह");
    namesMap.put("UN", "संयुक्त राष्ट्र");
    namesMap.put("US", "संयुक्त राज्य");
    namesMap.put("UY", "उरूग्वे");
    namesMap.put("UZ", "उज़्बेकिस्तान");
    namesMap.put("VA", "वेटिकन सिटी");
    namesMap.put("VC", "सेंट विंसेंट और ग्रेनाडाइंस");
    namesMap.put("VE", "वेनेज़ुएला");
    namesMap.put("VG", "ब्रिटिश वर्जिन द्वीपसमूह");
    namesMap.put("VI", "यू॰एस॰ वर्जिन द्वीपसमूह");
    namesMap.put("VN", "वियतनाम");
    namesMap.put("VU", "वनुआतू");
    namesMap.put("WF", "वालिस और फ़्यूचूना");
    namesMap.put("WS", "समोआ");
    namesMap.put("XK", "कोसोवो");
    namesMap.put("YE", "यमन");
    namesMap.put("YT", "मायोते");
    namesMap.put("ZA", "दक्षिण अफ़्रीका");
    namesMap.put("ZM", "ज़ाम्बिया");
    namesMap.put("ZW", "ज़िम्बाब्वे");
    namesMap.put("ZZ", "अज्ञात क्षेत्र");
  }

}
