/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.shared.cldr.impl;
// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA

/**
 * Implementation of DateTimeFormatInfo for the "ps_AF" locale.
 */

import org.gwtproject.i18n.shared.cldr.DateTimeFormatInfoImpl;

public class DateTimeFormatInfoImpl_ps_AF extends DateTimeFormatInfoImpl_ps {

  @Override
  public String[] ampms() {
    return new String[] {
        "غ.م.",
        "غ.و."
    };
  }

  @Override
  public String dateFormat() {
    return dateFormatMedium();
  }

  @Override
  public String dateFormatFull() {
    return "EEEE د y د MMMM d";
  }

  @Override
  public String dateFormatLong() {
    return "د y د MMMM d";
  }

  @Override
  public String dateFormatMedium() {
    return "y MMM d";
  }

  @Override
  public String dateFormatShort() {
    return "y/M/d";
  }

  @Override
  public String dateTime(String timePattern, String datePattern) {
    return dateTimeMedium(timePattern, datePattern);
  }

  @Override
  public String dateTimeFull(String timePattern, String datePattern) {
    return datePattern + " " + timePattern;
  }

  @Override
  public String dateTimeLong(String timePattern, String datePattern) {
    return datePattern + " " + timePattern;
  }

  @Override
  public String dateTimeMedium(String timePattern, String datePattern) {
    return datePattern + " " + timePattern;
  }

  @Override
  public String dateTimeShort(String timePattern, String datePattern) {
    return datePattern + " " + timePattern;
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "له میلاد څخه وړاندې",
        "له میلاد څخه وروسته"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "له میلاد وړاندې",
        "م."
    };
  }

  @Override
  public int firstDayOfTheWeek() {
    return 6;
  }

  @Override
  public String formatDay() {
    return "d";
  }

  @Override
  public String formatHour12Minute() {
    return "h:mm a";
  }

  @Override
  public String formatHour12MinuteSecond() {
    return "h:mm:ss a";
  }

  @Override
  public String formatHour24Minute() {
    return "H:mm";
  }

  @Override
  public String formatHour24MinuteSecond() {
    return "H:mm:ss";
  }

  @Override
  public String formatMinuteSecond() {
    return "mm:ss";
  }

  @Override
  public String formatMonthAbbrev() {
    return "LLL";
  }

  @Override
  public String formatMonthAbbrevDay() {
    return "MMM d";
  }

  @Override
  public String formatMonthFull() {
    return "LLLL";
  }

  @Override
  public String formatMonthFullDay() {
    return "d MMMM";
  }

  @Override
  public String formatMonthFullWeekdayDay() {
    return "MMMM d, EEEE";
  }

  @Override
  public String formatMonthNumDay() {
    return "M/d";
  }

  @Override
  public String formatYear() {
    return "G y";
  }

  @Override
  public String formatYearMonthAbbrev() {
    return "د G y د MMM";
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "G y MMM d";
  }

  @Override
  public String formatYearMonthFull() {
    return "د G y د MMMM";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "G y MMMM d";
  }

  @Override
  public String formatYearMonthNum() {
    return "G y/M";
  }

  @Override
  public String formatYearMonthNumDay() {
    return "GGGGG y-MM-dd";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "G y MMM d, EEE";
  }

  @Override
  public String formatYearQuarterFull() {
    return "G y QQQQ";
  }

  @Override
  public String formatYearQuarterShort() {
    return "G y Q";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "جنوري",
        "فبروري",
        "مارچ",
        "اپریل",
        "مۍ",
        "جون",
        "جولای",
        "اگست",
        "سېپتمبر",
        "اکتوبر",
        "نومبر",
        "دسمبر"
    };
  }

  @Override
  public String[] monthsFullStandalone() {
    return new String[] {
        "جنوري",
        "فېبروري",
        "مارچ",
        "اپریل",
        "مۍ",
        "جون",
        "جولای",
        "اگست",
        "سپتمبر",
        "اکتوبر",
        "نومبر",
        "دسمبر"
    };
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "ج",
        "ف",
        "م",
        "ا",
        "م",
        "ج",
        "ج",
        "ا",
        "س",
        "ا",
        "ن",
        "د"
    };
  }

  @Override
  public String[] monthsNarrowStandalone() {
    return new String[] {
        "1",
        "2",
        "3",
        "4",
        "5",
        "6",
        "7",
        "8",
        "9",
        "10",
        "11",
        "12"
    };
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "جنوري",
        "فبروري",
        "مارچ",
        "اپریل",
        "مۍ",
        "جون",
        "جولای",
        "اگست",
        "سېپتمبر",
        "اکتوبر",
        "نومبر",
        "دسمبر"
    };
  }

  @Override
  public String[] monthsShortStandalone() {
    return new String[] {
        "جنوري",
        "فبروري",
        "مارچ",
        "اپریل",
        "مۍ",
        "جون",
        "جولای",
        "اگست",
        "سپتمبر",
        "اکتوبر",
        "نومبر",
        "دسمبر"
    };
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "لومړۍ ربعه",
        "۲مه ربعه",
        "۳مه ربعه",
        "۴مه ربعه"
    };
  }

  @Override
  public String[] quartersShort() {
    return new String[] {
        "لومړۍ ربعه",
        "۲مه ربعه",
        "۳مه ربعه",
        "۴مه ربعه"
    };
  }

  @Override
  public String timeFormat() {
    return timeFormatMedium();
  }

  @Override
  public String timeFormatFull() {
    return "H:mm:ss (zzzz)";
  }

  @Override
  public String timeFormatLong() {
    return "H:mm:ss (z)";
  }

  @Override
  public String timeFormatMedium() {
    return "H:mm:ss";
  }

  @Override
  public String timeFormatShort() {
    return "H:mm";
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "يونۍ",
        "دونۍ",
        "درېنۍ",
        "څلرنۍ",
        "پينځنۍ",
        "جمعه",
        "اونۍ"
    };
  }

  @Override
  public String[] weekdaysFullStandalone() {
    return weekdaysFull();
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "S",
        "M",
        "T",
        "W",
        "T",
        "F",
        "S"
    };
  }

  @Override
  public String[] weekdaysNarrowStandalone() {
    return weekdaysNarrow();
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "يونۍ",
        "دونۍ",
        "درېنۍ",
        "څلرنۍ",
        "پينځنۍ",
        "جمعه",
        "اونۍ"
    };
  }

  @Override
  public String[] weekdaysShortStandalone() {
    return weekdaysShort();
  }

  @Override
  public int weekendEnd() {
    return 5;
  }

  @Override
  public int weekendStart() {
    return 4;
  }
}
