/*
 * Copyright © 2019 Dominokit
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dominokit.domino.ui.i18n;

/**
 * The {@code DefaultDominoUILabels} class is the default implementation of the {@link
 * DominoUILabels} interface. It serves as a placeholder for label-related methods and does not
 * provide any custom labels.
 *
 * <p>This class is provided as a default implementation to ensure that all required label-related
 * methods are available for internationalization purposes. Developers can extend this class to
 * provide custom label implementations.
 *
 * <p>This class is subject to the terms of the Apache License, Version 2.0.
 *
 * @see DominoUILabels
 */
public class DefaultDominoUILabels implements DominoUILabels {}
