/*
 * Copyright © 2019 Dominokit
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dominokit.domino.ui.collapsible;

import org.dominokit.domino.ui.style.CssClass;

/**
 * CSS style names for {@link org.dominokit.domino.ui.collapsible.Accordion} and {@link
 * org.dominokit.domino.ui.collapsible.AccordionPanel}
 */
public interface CollapsibleStyles {

  /** Constant <code>dui_collapse_group</code> */
  CssClass dui_collapse_group = () -> "dui-collapse-group";
  /** Constant <code>dui_collapse_panel</code> */
  CssClass dui_collapse_panel = () -> "dui-collapse-panel";
  /** Constant <code>dui_panel_header</code> */
  CssClass dui_panel_header = () -> "dui-panel-header";
  /** Constant <code>dui_panel_content_header</code> */
  CssClass dui_panel_content_header = () -> "dui-panel-content-header";
  /** Constant <code>dui_panel_icon</code> */
  CssClass dui_panel_icon = () -> "dui-panel-icon";
  /** Constant <code>dui_panel_title</code> */
  CssClass dui_panel_title = () -> "dui-panel-title";
  /** Constant <code>dui_panel_utility</code> */
  CssClass dui_panel_utility = () -> "dui-panel-utility";
  /** Constant <code>dui_panel_content</code> */
  CssClass dui_panel_content = () -> "dui-panel-content";
  /** Constant <code>dui_panel_body</code> */
  CssClass dui_panel_body = () -> "dui-panel-body";
  /** Constant <code>dui_panel_footer</code> */
  CssClass dui_panel_footer = () -> "dui-panel-footer";
  /** Constant <code>dui_height_collapsed</code> */
  CssClass dui_height_collapsed = () -> "dui-height-collapsed";
  /** Constant <code>dui_height_collapsed_overflow</code> */
  CssClass dui_height_collapsed_overflow = () -> "dui-height-collapsed-overflow";
  /** Constant <code>dui_height_collapsed_trans_100</code> */
  CssClass dui_height_collapsed_trans_100 = () -> "dui-height-collapsed-trans-100";
  /** Constant <code>dui_height_collapsed_trans_200</code> */
  CssClass dui_height_collapsed_trans_200 = () -> "dui-height-collapsed-trans-200";
  /** Constant <code>dui_height_collapsed_trans_300</code> */
  CssClass dui_height_collapsed_trans_300 = () -> "dui-height-collapsed-trans-300";
  /** Constant <code>dui_height_collapsed_trans_400</code> */
  CssClass dui_height_collapsed_trans_400 = () -> "dui-height-collapsed-trans-400";
  /** Constant <code>dui_height_collapsed_trans_500</code> */
  CssClass dui_height_collapsed_trans_500 = () -> "dui-height-collapsed-trans-500";
  /** Constant <code>dui_height_collapsed_trans_600</code> */
  CssClass dui_height_collapsed_trans_600 = () -> "dui-height-collapsed-trans-600";
  /** Constant <code>dui_height_collapsed_trans_700</code> */
  CssClass dui_height_collapsed_trans_700 = () -> "dui-height-collapsed-trans-700";
  /** Constant <code>dui_height_collapsed_trans_800</code> */
  CssClass dui_height_collapsed_trans_800 = () -> "dui-height-collapsed-trans-800";
  /** Constant <code>dui_height_collapsed_trans_900</code> */
  CssClass dui_height_collapsed_trans_900 = () -> "dui-height-collapsed-trans-900";
  /** Constant <code>dui_height_collapsed_trans_1000</code> */
  CssClass dui_height_collapsed_trans_1000 = () -> "dui-height-collapsed-trans-1000";
  /** Constant <code>dui_height_collapsed_trans_20000</code> */
  CssClass dui_height_collapsed_trans_20000 = () -> "dui-height-collapsed-trans-20000";
}
