/*
 * Copyright © 2019 Dominokit
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dominokit.domino.ui.carousel;

/** Default CSS classes for {@link Carousel} */
public class CarouselStyles {
  /** CSS class for carousel indicator */
  public static final String CAROUSEL_INDICATORS = "carousel-indicators";
  /** CSS class for slides container */
  public static final String CAROUSEL_INNER = "carousel-inner";
  /** CSS class for sliding controls */
  public static final String CAROUSEL_CONTROL = "carousel-control";
  /** CSS class for slide caption */
  public static final String CAROUSEL_CAPTION = "carousel-caption";
  /** CSS class for carousel */
  public static final String CAROUSEL = "carousel";
  /** CSS class for active slide */
  public static final String ACTIVE = "active";
  /** CSS class for animate sliding to the left */
  public static final String LEFT = "left";
  /** CSS class for animate sliding to the right */
  public static final String RIGHT = "right";
  /** CSS class for next indicator */
  public static final String NEXT = "next";
  /** CSS class for previous indicator */
  public static final String PREV = "prev";
  /** CSS class for slide */
  public static final String ITEM = "item";
}
