/*
 * Copyright © 2019 Dominokit
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dominokit.domino.ui.alerts;

/** Default CSS classes for {@link Alert} */
public class AlertStyles {

  /** CSS class for alert */
  public static final String ALERT = "alert";
  /** CSS class for alert with success severity */
  public static final String SUCCESS = "alert-success";
  /** CSS class for alert with info severity */
  public static final String INFO = "alert-info";
  /** CSS class for alert with warning severity */
  public static final String WARNING = "alert-warning";
  /** CSS class for alert with error severity */
  public static final String ERROR = "alert-danger";
  /** CSS class for the close button */
  public static final String CLOSE = "close";
  /** CSS class for setting the alert as dismissible */
  public static final String ALERT_DISMISSIBLE = "alert-dismissible";
  /** CSS class for links inside alert */
  public static final String ALERT_LINK = "alert-link";
}
