/*
 * Copyright © 2019 Dominokit
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dominokit.domino.ui.upload;

/**
 * An enum representing the drop effect
 *
 * <p>More information can be found in <a
 * href="https://developer.mozilla.org/en-US/docs/Web/API/DataTransfer/dropEffect">MDN official
 * documentation</a>
 */
public enum DropEffect {
  COPY("copy"),
  MOVE("move"),
  LINK("link"),
  NONE("none");

  private final String effect;

  DropEffect(String effect) {
    this.effect = effect;
  }

  /** @return the effect */
  public String getEffect() {
    return effect;
  }
}
