/*
 * Copyright © 2019 Dominokit
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dominokit.domino.ui.grid.flex;

/** Default CSS classes for {@link FlexLayout} and {@link FlexItem} */
public class FlexStyles {
  /** CSS class for a flex layout */
  public static final String FLEX_LAYOUT = "flex-layout";
  /** CSS class for a flex item */
  public static final String FLEX_ITEM = "flex-item";
  /** CSS style of baseline alignment */
  public static final String FLEX_ALIGN_BASELINE = "flex-align-baseline";
  /** CSS style of start alignment */
  public static final String FLEX_ALIGN_START = "flex-align-start";
  /** CSS style of end alignment */
  public static final String FLEX_ALIGN_END = "flex-align-end";
  /** CSS style of center alignment */
  public static final String FLEX_ALIGN_CENTER = "flex-align-center";
  /** CSS style of stretch alignment */
  public static final String FLEX_ALIGN_STRETCH = "flex-align-stretch";

  /** CSS style of left to right flex direction */
  public static final String FLEX_DIR_ROW = "flex-dir-row";
  /** CSS style of right to left flex direction */
  public static final String FLEX_DIR_ROW_REVERSE = "flex-dir-row-reverse";
  /** CSS style of top to bottom flex direction */
  public static final String FLEX_DIR_COLUMN = "flex-dir-column";
  /** CSS style of bottom to top flex direction */
  public static final String FLEX_DIR_COLUMN_REVERSE = "flex-dir-column-reverse";

  /** CSS style of start flex justify content */
  public static final String FLEX_JUST_START = "flex-just-start";
  /** CSS style of end flex justify content */
  public static final String FLEX_JUST_END = "flex-just-end";
  /** CSS style of center flex justify content */
  public static final String FLEX_JUST_CENTER = "flex-just-center";
  /** CSS style of space between flex justify content */
  public static final String FLEX_JUST_SPACE_BETWEEN = "flex-just-space-between";
  /** CSS style of space around flex justify content */
  public static final String FLEX_JUST_SPACE_AROUND = "flex-just-space-around";
  /** CSS style of space evenly flex justify content */
  public static final String FLEX_JUST_SPACE_EVENLY = "flex-just-space-evenly";

  /** CSS style of no wrap flex wrap */
  public static final String FLEX_WRAP_NOWRAP = "flex-wrap-nowrap";
  /** CSS style of top to bottom flex wrap */
  public static final String FLEX_WRAP_WRAP = "flex-wrap-wrap";
  /** CSS style of bottom to top flex wrap */
  public static final String FLEX_WRAP_WRAP_REVERSE = "flex-wrap-wrap-reverse";
}
