/*
 * Copyright © 2019 Dominokit
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dominokit.domino.ui.datepicker;

/** Default CSS classes for {@link DatePicker} */
public class DatePickerStyles {
  /** CSS class for date picker calendar element */
  public static final String CALENDAR = "calendar";
  /** CSS class for the date panel */
  public static final String DATE_PANEL = "date-panel";
  /** CSS class for selectors container */
  public static final String SELECTOR_CONTAINER = "selector-container";
  /** CSS class for the footer of the date picker */
  public static final String CAL_FOOTER = "cal-footer";
  /** CSS class for day name element */
  public static final String DAY_NAME = "day-name";
  /** CSS class for month name element */
  public static final String MONTH_NAME = "month-name";
  /** CSS class for day number element */
  public static final String DAY_NUMBER = "day-number";
  /** CSS class for year number element */
  public static final String YEAR_NUMBER = "year-number";
  /** CSS class for a date picker button element */
  public static final String CAL_BUTTON = "cal-button";
  /** CSS class for selectors row element */
  public static final String SELECTOR_ROW = "selector-row";
  /** CSS class for a selector */
  public static final String SELECTOR = "selector";
  /** CSS class for a selected element */
  public static final String SELECTED = "selected";
  /** CSS class for a date picker container */
  public static final String DATE_PICKER_CONTAINER = "date-picker-container";
  /** CSS class for a date picker */
  public static final String DATE_PICKER = "date-picker";
  /** CSS class for an other month element */
  public static final String OTHER_MONTH = "other-month";
  /** CSS class for a current month element */
  public static final String CURRENT_MONTH = "current-month";
  /** CSS class for a date picker popover */
  public static final String PICKER_POPOVER = "picker-popover";
}
