/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.domino.http.server.config;

import com.google.auto.service.AutoService;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.net.PemKeyCertOptions;
import org.dominokit.domino.api.server.config.HttpServerConfigurator;
import org.dominokit.domino.api.server.config.ServerConfiguration;
import org.dominokit.domino.api.server.entrypoint.VertxContext;

@AutoService(value={HttpServerConfigurator.class})
public class PemCertificateConfigurator
implements HttpServerConfigurator {
    private static final String CERTIFICAT_PATH = "app.ssl.certificate.path";

    public void configureHttpServer(VertxContext context, HttpServerOptions options) {
        if (this.pemEnabled(context.config())) {
            this.applyConfigurations(context.config(), options);
        }
    }

    private boolean pemEnabled(ServerConfiguration config) {
        return config.getBoolean("ssl.pem.enabled", Boolean.valueOf(false));
    }

    private void applyConfigurations(ServerConfiguration configuration, HttpServerOptions options) {
        this.validateConfiguration(configuration);
        if (this.sslEnabled(configuration).booleanValue()) {
            this.enableSsl(configuration, options);
        }
    }

    private void enableSsl(ServerConfiguration config, HttpServerOptions options) {
        options.setSsl(Boolean.TRUE.booleanValue());
        options.setHost("localhost");
        options.setPemKeyCertOptions(new PemKeyCertOptions().setCertPath(this.getPath(config)).setKeyPath(this.getPath(config))).setPort(this.getPort(config));
    }

    private String getPath(ServerConfiguration configuration) {
        return configuration.getString(CERTIFICAT_PATH);
    }

    private int getPort(ServerConfiguration configuration) {
        return configuration.getInteger("https.port", Integer.valueOf(443));
    }

    private void validateConfiguration(ServerConfiguration configuration) {
        if (this.sslEnabled(configuration).booleanValue()) {
            this.validateSslPathAndPassword(configuration);
        }
    }

    private Boolean sslEnabled(ServerConfiguration configuration) {
        return configuration.getBoolean("ssl.enabled", Boolean.valueOf(false));
    }

    private void validateSslPathAndPassword(ServerConfiguration configuration) {
        if (this.missingCertificatePath(configuration)) {
            throw new MissingCertificatePathInConfigurationException();
        }
    }

    private boolean missingCertificatePath(ServerConfiguration configuration) {
        return configuration.getString(CERTIFICAT_PATH, "").isEmpty();
    }

    class MissingCertificatePathInConfigurationException
    extends RuntimeException {
        MissingCertificatePathInConfigurationException() {
        }
    }
}

