/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.domino.test.api.client;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import java.util.HashMap;
import java.util.Map;
import org.dominokit.domino.api.client.ClientApp;
import org.dominokit.domino.api.server.resource.ResourcesRepository;
import org.dominokit.domino.test.api.client.TestRequestAsyncSender;
import org.dominokit.domino.test.api.client.TestRoutingListener;
import org.dominokit.rest.shared.Event;
import org.dominokit.rest.shared.EventsBus;
import org.dominokit.rest.shared.request.FailedResponseBean;
import org.dominokit.rest.shared.request.Request;
import org.dominokit.rest.shared.request.RequestAsyncSender;
import org.dominokit.rest.shared.request.RequestRouter;
import org.dominokit.rest.shared.request.RequestStateContext;
import org.dominokit.rest.shared.request.ResponseBean;
import org.dominokit.rest.shared.request.ServerRequest;
import org.dominokit.rest.shared.request.ServerRequestEventFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestServerRouter
implements RequestRouter<ServerRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestServerRouter.class);
    private Map<String, ResponseReply> fakeResponses = new HashMap<String, ResponseReply>();
    private Map<String, Future<ResponseReply>> requestCompleteHandlers = new HashMap<String, Future<ResponseReply>>();
    private final RequestAsyncSender requestAsyncRunner;
    private TestRoutingListener defaultListener = new TestRoutingListener();
    private RoutingListener listener = this.defaultListener;
    private final ServerRequestEventFactory eventFactory = new ServerRequestEventFactory(){

        public <T> Event makeSuccess(ServerRequest request, T responseBean) {
            TestServerRouter.this.defaultListener.onRouteRequest(request, responseBean);
            return new TestServerSuccessEvent<T>(request, responseBean);
        }

        public Event makeFailed(ServerRequest request, FailedResponseBean failedResponseBean) {
            TestServerRouter.this.defaultListener.onRouteRequest(request, failedResponseBean);
            return new TestServerFailedEvent(request, failedResponseBean);
        }
    };

    public TestServerRouter(Vertx vertx) {
        this.requestAsyncRunner = new TestRequestAsyncSender(this.eventFactory);
    }

    public void setRoutingListener(RoutingListener listener) {
        this.listener = listener;
    }

    public void removeRoutingListener() {
        this.listener = this.defaultListener;
    }

    public void routeRequest(ServerRequest request) {
        try {
            if (this.fakeResponses.containsKey(this.getRequestKey(request))) {
                Object response = this.fakeResponses.get(this.getRequestKey(request)).reply();
                this.eventFactory.makeSuccess(request, response).fire();
            } else {
                this.requestAsyncRunner.send(request);
            }
        }
        catch (ResourcesRepository.RequestHandlerNotFound ex) {
            LOGGER.error("Request resource not found for request [" + request.getClass().getSimpleName() + "]! either fake the request or start an actual server");
            this.eventFactory.makeFailed(request, new FailedResponseBean((Throwable)ex)).fire();
        }
        catch (FakeRequestFailure ex) {
            LOGGER.error("could not execute request : ", (Throwable)ex);
            this.eventFactory.makeFailed(request, ex.failedResponseBean).fire();
        }
        catch (Exception ex) {
            LOGGER.error("could not execute request : ", (Throwable)ex);
            this.eventFactory.makeFailed(request, new FailedResponseBean((Throwable)ex)).fire();
        }
    }

    private String getRequestKey(ServerRequest request) {
        return request.getClass().getCanonicalName();
    }

    private String getRequestKey(Class<? extends ServerRequest> request) {
        return request.getCanonicalName();
    }

    public void fakeResponse(String requestKey, ResponseReply reply) {
        this.fakeResponses.put(requestKey, reply);
    }

    public TestRoutingListener getDefaultRoutingListener() {
        return this.defaultListener;
    }

    public void onRequestCompleted(Class<? extends ServerRequest> request, Future<ResponseReply> completeHandler) {
        this.requestCompleteHandlers.put(this.getRequestKey(request), completeHandler);
    }

    private void completeSuccessRequest(ServerRequest request, ResponseReply reply) {
        String requestKey = this.getRequestKey(request);
        if (this.requestCompleteHandlers.containsKey(requestKey)) {
            this.requestCompleteHandlers.get(requestKey).complete((Object)reply);
            this.requestCompleteHandlers.remove(requestKey);
        }
    }

    private void completeFailRequest(ServerRequest request, FailedReply reply) {
        String requestKey = this.getRequestKey(request);
        if (this.requestCompleteHandlers.containsKey(requestKey)) {
            this.requestCompleteHandlers.get(requestKey).fail((Throwable)new TestFailedRequestException(reply));
            this.requestCompleteHandlers.remove(requestKey);
        }
    }

    public static final class TestFailedRequestException
    extends Exception {
        private final FailedReply failedReply;

        public TestFailedRequestException(FailedReply failedReply) {
            this.failedReply = failedReply;
        }

        public FailedReply getFailedReply() {
            return this.failedReply;
        }
    }

    private static class FakeRequestFailure
    extends RuntimeException {
        private final FailedResponseBean failedResponseBean;

        public FakeRequestFailure(FailedResponseBean failedResponseBean) {
            this.failedResponseBean = failedResponseBean;
        }
    }

    public static class FailedReply
    implements ResponseReply {
        private final FailedResponseBean failedResponseBean;

        public FailedReply(FailedResponseBean failedResponseBean) {
            this.failedResponseBean = failedResponseBean;
        }

        public ResponseBean reply() {
            throw new FakeRequestFailure(this.failedResponseBean);
        }
    }

    public static class SuccessReply<T>
    implements ResponseReply {
        private final T response;

        public SuccessReply(T response) {
            this.response = response;
        }

        @Override
        public T reply() {
            return this.response;
        }
    }

    public static interface ResponseReply {
        public <T> T reply();
    }

    public static interface RoutingListener {
        public void onRouteRequest(ServerRequest var1, Object var2);
    }

    public class TestFailedRequestEvent
    implements EventsBus.RequestEvent<TestServerFailedEvent> {
        private final TestServerFailedEvent event;

        public TestFailedRequestEvent(TestServerFailedEvent event) {
            this.event = event;
        }

        public TestServerFailedEvent asEvent() {
            return this.event;
        }
    }

    public class TestServerFailedEvent
    implements Event {
        protected final ServerRequest request;
        protected final FailedResponseBean failedResponseBean;
        private final ClientApp clientApp = ClientApp.make();

        public TestServerFailedEvent(ServerRequest request, FailedResponseBean failedResponseBean) {
            this.request = request;
            this.failedResponseBean = failedResponseBean;
        }

        public void fire() {
            this.clientApp.getEventsBus().publishEvent((EventsBus.RequestEvent)new TestFailedRequestEvent(this));
        }

        public void process() {
            this.request.applyState((RequestStateContext)new Request.ServerResponseReceivedStateContext((RequestStateContext)this.makeFailedContext()));
            TestServerRouter.this.completeFailRequest(this.request, new FailedReply(this.failedResponseBean));
        }

        private Request.ServerFailedRequestStateContext makeFailedContext() {
            return new Request.ServerFailedRequestStateContext(this.failedResponseBean);
        }
    }

    public class TestSuccessRequestEvent
    implements EventsBus.RequestEvent<TestServerSuccessEvent> {
        private final TestServerSuccessEvent event;

        public TestSuccessRequestEvent(TestServerSuccessEvent event) {
            this.event = event;
        }

        public TestServerSuccessEvent asEvent() {
            return this.event;
        }
    }

    public class TestServerSuccessEvent<T>
    implements Event {
        protected final ServerRequest request;
        protected final T responseBean;
        private final ClientApp clientApp = ClientApp.make();

        public TestServerSuccessEvent(ServerRequest request, T responseBean) {
            this.request = request;
            this.responseBean = responseBean;
        }

        public void fire() {
            this.clientApp.getEventsBus().publishEvent((EventsBus.RequestEvent)new TestSuccessRequestEvent(this));
        }

        public void process() {
            this.request.applyState((RequestStateContext)new Request.ServerResponseReceivedStateContext((RequestStateContext)this.makeSuccessContext()));
            TestServerRouter.this.completeSuccessRequest(this.request, new SuccessReply<T>(this.responseBean));
        }

        private Request.ServerSuccessRequestStateContext makeSuccessContext() {
            return new Request.ServerSuccessRequestStateContext(this.responseBean);
        }
    }
}

