/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.domino.test.api.client;

import java.util.HashMap;
import java.util.Map;
import org.dominokit.domino.test.api.client.TestServerRouter;
import org.dominokit.rest.shared.request.ServerRequest;

public class TestRoutingListener
implements TestServerRouter.RoutingListener {
    private Map<String, RequestResponsePair> receivedRequests = new HashMap<String, RequestResponsePair>();

    @Override
    public void onRouteRequest(ServerRequest request, Object response) {
        if (this.receivedRequests.containsKey(request.getClass().getCanonicalName())) {
            this.receivedRequests.get(request.getClass().getCanonicalName()).increment(request, response);
        } else {
            this.receivedRequests.put(request.getClass().getCanonicalName(), new RequestResponsePair(request, response));
        }
    }

    public <R extends ServerRequest> boolean isSent(Class<R> request) {
        return this.receivedRequests.containsKey(request.getCanonicalName());
    }

    public <R extends ServerRequest> boolean isSent(Class<R> request, int executionCount) {
        return this.receivedRequests.containsKey(request.getCanonicalName()) && this.receivedRequests.get(request.getCanonicalName()).executionsCount == executionCount;
    }

    public <S, R extends ServerRequest> S getResponse(Class<R> request) {
        return (S)this.receivedRequests.get(request.getCanonicalName()).response;
    }

    public <R extends ServerRequest> R getRequest(Class<R> request) {
        return (R)this.receivedRequests.get(request.getCanonicalName()).request;
    }

    private class RequestResponsePair {
        private ServerRequest request;
        private Object response;
        private int executionsCount;

        public RequestResponsePair(ServerRequest request, Object response) {
            this.request = request;
            this.response = response;
            this.executionsCount = 0;
        }

        public int getExecutionsCount() {
            return this.executionsCount;
        }

        private void increment(ServerRequest request, Object response) {
            this.request = request;
            this.response = response;
            ++this.executionsCount;
        }
    }
}

