/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.domino.test.api.client;

import io.vertx.core.Vertx;
import org.dominokit.domino.api.client.ClientApp;
import org.dominokit.domino.api.client.DominoOptions;
import org.dominokit.domino.api.client.async.AsyncRunner;
import org.dominokit.domino.api.client.extension.DominoEventsListenersRepository;
import org.dominokit.domino.api.client.extension.PresentersNamesRegistry;
import org.dominokit.domino.api.client.mvp.slots.SlotsManager;
import org.dominokit.domino.history.AppHistory;
import org.dominokit.domino.test.api.client.FakeDominoOptions;
import org.dominokit.domino.test.api.client.TestAsyncRunner;
import org.dominokit.domino.test.api.client.TestClientRouter;
import org.dominokit.domino.test.api.client.TestEventBus;
import org.dominokit.domino.test.api.client.TestInMemoryEventsListenersRepository;
import org.dominokit.domino.test.api.client.TestNamedPresenters;
import org.dominokit.domino.test.api.client.TestServerRouter;
import org.dominokit.domino.test.api.client.TestSlotsManager;
import org.dominokit.domino.test.history.TestDominoHistory;
import org.dominokit.rest.DominoRestConfig;
import org.dominokit.rest.shared.EventProcessor;
import org.dominokit.rest.shared.EventsBus;
import org.dominokit.rest.shared.request.RequestRouter;

public class TestClientAppFactory {
    protected static TestServerRouter serverRouter;
    protected static TestInMemoryEventsListenersRepository listenersRepository;
    protected static TestDominoHistory history;
    protected static TestClientRouter clientRouter;
    protected static EventProcessor requestEventProcessor;
    protected static TestEventBus eventBus;
    protected static FakeDominoOptions dominoOptions;

    private TestClientAppFactory() {
    }

    public static ClientApp make(Vertx vertx) {
        clientRouter = new TestClientRouter();
        serverRouter = new TestServerRouter(vertx);
        requestEventProcessor = new EventProcessor();
        eventBus = new TestEventBus(requestEventProcessor);
        listenersRepository = new TestInMemoryEventsListenersRepository();
        history = new TestDominoHistory();
        dominoOptions = new FakeDominoOptions();
        DominoRestConfig.initDefaults();
        ClientApp clientApp = ClientApp.ClientAppBuilder.clientRouter((RequestRouter)clientRouter).eventsBus((EventsBus)eventBus).eventsListenersRepository((DominoEventsListenersRepository)listenersRepository).history((AppHistory)history).asyncRunner((AsyncRunner)new TestAsyncRunner()).dominoOptions((DominoOptions)dominoOptions).slotsManager((SlotsManager)new TestSlotsManager()).presentersNamesRegistry((PresentersNamesRegistry)new TestNamedPresenters()).build();
        return clientApp;
    }
}

