/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.domino.test.api.client;

import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import org.dominokit.domino.test.api.client.DominoTest;
import org.dominokit.domino.test.api.client.annotations.AutoStart;
import org.dominokit.domino.test.api.client.annotations.StartServer;
import org.junit.Test;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;

public class DominoTestRunner
extends VertxUnitRunner {
    private final Class<?> testClass;

    public DominoTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
        this.testClass = klass;
    }

    protected void invokeTestMethod(FrameworkMethod fMethod, Object test, TestContext context) throws InvocationTargetException, IllegalAccessException {
        if (Objects.nonNull(fMethod.getAnnotation(Test.class))) {
            AutoStart autoStart;
            DominoTest dominoTest = (DominoTest)test;
            StartServer startServer = (StartServer)fMethod.getAnnotation(StartServer.class);
            if (Objects.isNull(startServer)) {
                startServer = this.testClass.getAnnotation(StartServer.class);
            }
            if (Objects.nonNull(startServer) && startServer.value()) {
                dominoTest.getTestClient().withServer(context);
            }
            if (Objects.isNull(autoStart = (AutoStart)fMethod.getAnnotation(AutoStart.class)) || autoStart.value()) {
                String configFile = Objects.isNull(autoStart) ? "config.json" : autoStart.configFile();
                dominoTest.getTestClient().start(configFile, dominoTest.getAdditionalConfig(), () -> {
                    try {
                        this.doInvokeTestMethod(fMethod, test, context);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new IllegalStateException(e);
                    }
                });
            } else {
                try {
                    this.doInvokeTestMethod(fMethod, test, context);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IllegalStateException(e);
                }
            }
        } else {
            this.doInvokeTestMethod(fMethod, test, context);
        }
    }

    private void doInvokeTestMethod(FrameworkMethod fMethod, Object test, TestContext context) throws InvocationTargetException, IllegalAccessException {
        super.invokeTestMethod(fMethod, test, context);
    }
}

