/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.org.xhtmlrenderer.docx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.docx4j.org.xhtmlrenderer.css.constants.IdentValue;
import org.docx4j.org.xhtmlrenderer.docx.Docx4jFontDescription;

public class Docx4jFontFamily {
    private String _name;
    private List _fontDescriptions;
    private static final int SM_EXACT = 1;
    private static final int SM_LIGHTER_OR_DARKER = 2;
    private static final int SM_DARKER_OR_LIGHTER = 3;

    public List getFontDescriptions() {
        return this._fontDescriptions;
    }

    public void addFontDescription(Docx4jFontDescription descr) {
        if (this._fontDescriptions == null) {
            this._fontDescriptions = new ArrayList();
        }
        this._fontDescriptions.add(descr);
        Collections.sort(this._fontDescriptions, new Comparator(){

            public int compare(Object o1, Object o2) {
                Docx4jFontDescription f1 = (Docx4jFontDescription)o1;
                Docx4jFontDescription f2 = (Docx4jFontDescription)o2;
                return f1.getWeight() - f2.getWeight();
            }
        });
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public Docx4jFontDescription match(int desiredWeight, IdentValue style) {
        Docx4jFontDescription[] matches;
        Docx4jFontDescription result;
        if (this._fontDescriptions == null) {
            throw new RuntimeException("fontDescriptions is null");
        }
        ArrayList<Docx4jFontDescription> candidates = new ArrayList<Docx4jFontDescription>();
        for (Docx4jFontDescription description : this._fontDescriptions) {
            if (description.getStyle() != style) continue;
            candidates.add(description);
        }
        if (candidates.size() == 0) {
            if (style == IdentValue.ITALIC) {
                return this.match(desiredWeight, IdentValue.OBLIQUE);
            }
            if (style == IdentValue.OBLIQUE) {
                return this.match(desiredWeight, IdentValue.NORMAL);
            }
            candidates.addAll(this._fontDescriptions);
        }
        if ((result = this.findByWeight(matches = candidates.toArray(new Docx4jFontDescription[candidates.size()]), desiredWeight, 1)) != null) {
            return result;
        }
        if (desiredWeight <= 500) {
            return this.findByWeight(matches, desiredWeight, 2);
        }
        return this.findByWeight(matches, desiredWeight, 3);
    }

    private Docx4jFontDescription findByWeight(Docx4jFontDescription[] matches, int desiredWeight, int searchMode) {
        if (searchMode == 1) {
            for (int i = 0; i < matches.length; ++i) {
                Docx4jFontDescription descr = matches[i];
                if (descr.getWeight() != desiredWeight) continue;
                return descr;
            }
            return null;
        }
        if (searchMode == 2) {
            int offset = 0;
            Docx4jFontDescription descr = null;
            for (offset = 0; offset < matches.length && (descr = matches[offset]).getWeight() <= desiredWeight; ++offset) {
            }
            if (offset > 0 && descr.getWeight() > desiredWeight) {
                return matches[offset - 1];
            }
            return descr;
        }
        if (searchMode == 3) {
            int offset = 0;
            Docx4jFontDescription descr = null;
            for (offset = matches.length - 1; offset >= 0 && (descr = matches[offset]).getWeight() >= desiredWeight; --offset) {
            }
            if (offset != matches.length - 1 && descr.getWeight() < desiredWeight) {
                return matches[offset + 1];
            }
            return descr;
        }
        return null;
    }
}

