/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.fo;

import java.util.List;
import org.docx4j.convert.out.AbstractConversionSettings;
import org.docx4j.convert.out.FORenderer;
import org.docx4j.convert.out.FOSettings;
import org.docx4j.convert.out.common.AbstractWmlConversionContext;
import org.docx4j.convert.out.common.AbstractWriterRegistry;
import org.docx4j.convert.out.common.ConversionSectionWrapper;
import org.docx4j.convert.out.common.ConversionSectionWrappers;
import org.docx4j.convert.out.common.Writer;
import org.docx4j.convert.out.common.writer.AbstractMessageWriter;
import org.docx4j.convert.out.fo.BookmarkStartWriter;
import org.docx4j.convert.out.fo.BrWriter;
import org.docx4j.convert.out.fo.FOConversionImageHandler;
import org.docx4j.convert.out.fo.FOPictWriterFloatUsed;
import org.docx4j.convert.out.fo.FldSimpleWriter;
import org.docx4j.convert.out.fo.HyperlinkWriter;
import org.docx4j.convert.out.fo.SymbolWriter;
import org.docx4j.convert.out.fo.TableWriter;
import org.docx4j.convert.out.fo.renderers.FORendererApacheFOP;
import org.docx4j.convert.out.fo.renderers.FORendererDummy;
import org.docx4j.fonts.RunFontSelector;
import org.docx4j.model.images.ConversionImageHandler;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public class FOConversionContext
extends AbstractWmlConversionContext {
    private static Logger log = LoggerFactory.getLogger(FOConversionContext.class);
    protected boolean requires2PassChecked = false;
    protected boolean requires2Pass = false;
    protected FORenderer foRenderer;
    protected static final AbstractWriterRegistry FO_WRITER_REGISTRY = new AbstractWriterRegistry(){

        protected void registerDefaultWriterInstances() {
            this.registerWriter((Writer)new TableWriter());
            this.registerWriter((Writer)new SymbolWriter());
            this.registerWriter((Writer)new BrWriter());
            this.registerWriter((Writer)new FldSimpleWriter());
            this.registerWriter((Writer)new BookmarkStartWriter());
            this.registerWriter((Writer)new HyperlinkWriter());
            this.registerWriter((Writer)new FOPictWriterFloatUsed());
        }
    };
    protected static final AbstractMessageWriter FO_MESSAGE_WRITER = new AbstractMessageWriter(){

        protected String getOutputPrefix() {
            return "<fo:block xmlns:fo=\"http://www.w3.org/1999/XSL/Format\"  font-size=\"12pt\" color=\"red\" font-family=\"sans-serif\" line-height=\"15pt\" space-after.optimum=\"3pt\" text-align=\"justify\"> ";
        }

        protected String getOutputSuffix() {
            return "</fo:block>";
        }
    };

    public FOConversionContext(FOSettings settings, WordprocessingMLPackage wmlPackage, ConversionSectionWrappers conversionSectionWrappers) {
        super(FO_WRITER_REGISTRY, FO_MESSAGE_WRITER, (AbstractConversionSettings)settings, wmlPackage, conversionSectionWrappers, FOConversionContext.createRunFontSelector(wmlPackage));
        this.foRenderer = this.initializeFoRenderer(settings);
    }

    private static RunFontSelector createRunFontSelector(WordprocessingMLPackage wmlPackage) {
        return new RunFontSelector(wmlPackage, new RunFontSelector.RunFontCharacterVisitor(){
            DocumentFragment df;
            StringBuilder sb = new StringBuilder(1024);
            Element span;
            String lastFont;
            String fallbackFontName;
            private Document document;
            private boolean spanReusable = true;
            private RunFontSelector runFontSelector;

            public void setDocument(Document document) {
                this.document = document;
                this.df = document.createDocumentFragment();
            }

            public boolean isReusable() {
                return this.spanReusable;
            }

            public void addCharacterToCurrent(char c) {
                this.sb.append(c);
            }

            public void addCodePointToCurrent(int cp) {
                this.sb.append(new String(Character.toChars(cp)));
            }

            public void finishPrevious() {
                if (this.sb.length() > 0) {
                    if (this.span == null) {
                        this.span = this.runFontSelector.createElement(this.document);
                        if (this.lastFont != null) {
                            this.runFontSelector.setAttribute(this.span, this.lastFont);
                        }
                    }
                    this.df.appendChild(this.span);
                    this.span.setTextContent(this.sb.toString());
                    this.sb.setLength(0);
                }
            }

            public void createNew() {
                this.span = this.runFontSelector.createElement(this.document);
            }

            public void setMustCreateNewFlag(boolean val) {
                this.spanReusable = !val;
            }

            public void fontAction(String fontname) {
                if (fontname == null) {
                    this.runFontSelector.setAttribute(this.span, this.fallbackFontName);
                } else {
                    this.runFontSelector.setAttribute(this.span, fontname);
                    this.lastFont = fontname;
                }
            }

            public Object getResult() {
                this.span = null;
                return this.df;
            }

            public void setRunFontSelector(RunFontSelector runFontSelector) {
                this.runFontSelector = runFontSelector;
            }

            public void setFallbackFont(String fontname) {
                this.fallbackFontName = fontname;
            }
        }, RunFontSelector.RunFontActionType.XSL_FO);
    }

    protected FORenderer initializeFoRenderer(FOSettings settings) {
        FORenderer ret = settings.getCustomFoRenderer();
        if (ret == null) {
            if ("application/xml-fo".equals(settings.getApacheFopMime())) {
                ret = FORendererDummy.getInstance();
                this.forceRequires1Pass();
            } else {
                ret = FORendererApacheFOP.getInstance();
            }
            settings.setCustomFoRenderer(ret);
        }
        return ret;
    }

    protected ConversionImageHandler initializeImageHandler(AbstractConversionSettings settings, ConversionImageHandler handler) {
        if (handler == null) {
            handler = settings.getImageDirPath() != null ? new FOConversionImageHandler(settings.getImageDirPath(), true) : new FOConversionImageHandler();
        }
        return handler;
    }

    public FORenderer getFORenderer() {
        return this.foRenderer;
    }

    public void forceRequires1Pass() {
        this.requires2PassChecked = true;
        this.requires2Pass = false;
    }

    public boolean isRequires2Pass() {
        if (!this.requires2PassChecked) {
            this.requires2Pass = this.checkRequires2Pass();
            this.requires2PassChecked = true;
        }
        return this.requires2Pass;
    }

    protected boolean checkRequires2Pass() {
        boolean ret = false;
        boolean sectionPagesUsed = false;
        ConversionSectionWrapper wrapper = null;
        List wrapperList = this.getSections().getList();
        for (int i = 0; !ret && i < wrapperList.size(); ++i) {
            wrapper = (ConversionSectionWrapper)wrapperList.get(i);
            if (wrapper.getPageNumberInformation().getPageStart() > -1) {
                boolean bl = ret = i == 0 && wrapper.getPageNumberInformation().getPageStart() != 1 || i > 0;
            }
            if (!wrapper.getPageNumberInformation().isSectionpagesPresent()) continue;
            sectionPagesUsed = true;
        }
        return ret || sectionPagesUsed && wrapperList.size() > 1;
    }
}

