/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.fo;

import java.util.List;
import org.docx4j.convert.out.FOSettings;
import org.docx4j.convert.out.common.AbstractVisitorExporterDelegate;
import org.docx4j.convert.out.common.AbstractWmlConversionContext;
import org.docx4j.convert.out.common.ConversionSectionWrapper;
import org.docx4j.convert.out.common.XsltCommonFunctions;
import org.docx4j.convert.out.fo.FOConversionContext;
import org.docx4j.convert.out.fo.FOExporterVisitorGenerator;
import org.docx4j.convert.out.fo.LayoutMasterSetBuilder;
import org.docx4j.model.fields.FormattingSwitchHelper;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.wml.Ftr;
import org.docx4j.wml.Hdr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FOExporterVisitorDelegate
extends AbstractVisitorExporterDelegate<FOSettings, FOConversionContext> {
    private static String XSL_FO = "http://www.w3.org/1999/XSL/Format";

    protected FOExporterVisitorDelegate() {
        super(FOExporterVisitorGenerator.GENERATOR_FACTORY);
    }

    protected Element createDocumentRoot(FOConversionContext conversionContext, Document document) throws Docx4JException {
        return document.createElementNS(XSL_FO, "root");
    }

    protected void appendDocumentHeader(FOConversionContext conversionContext, Document document, Element documentRoot) throws Docx4JException {
        LayoutMasterSetBuilder.appendLayoutMasterSetFragment(conversionContext, documentRoot);
    }

    protected Element createSectionRoot(FOConversionContext conversionContext, Document document, ConversionSectionWrapper sectionWrapper, Element currentParent) throws Docx4JException {
        Element pageSequence = document.createElementNS(XSL_FO, "page-sequence");
        int pageNumberInitial = sectionWrapper.getPageNumberInformation().getPageStart();
        String pageFormat = sectionWrapper.getPageNumberInformation().getPageFormat();
        pageSequence.setAttribute("master-reference", sectionWrapper.getId());
        pageSequence.setAttribute("id", "section_" + sectionWrapper.getId());
        pageFormat = FormattingSwitchHelper.getFoPageNumberFormat((String)pageFormat);
        if (pageNumberInitial > -1) {
            pageSequence.setAttribute("initial-page-number", Integer.toString(pageNumberInitial));
        }
        if (pageFormat != null) {
            pageSequence.setAttribute("format", pageFormat);
        }
        return pageSequence;
    }

    protected void appendSectionHeader(FOConversionContext conversionContext, Document document, ConversionSectionWrapper sectionWrapper, Element currentParent) throws Docx4JException {
        Object staticContent = null;
        if (XsltCommonFunctions.hasFirstHeader((AbstractWmlConversionContext)conversionContext)) {
            this.appendPartContent(conversionContext, document, currentParent, "xsl-region-before-firstpage", (Part)sectionWrapper.getHeaderFooterPolicy().getFirstHeader(), ((Hdr)sectionWrapper.getHeaderFooterPolicy().getFirstHeader().getJaxbElement()).getContent());
        }
        if (XsltCommonFunctions.hasFirstFooter((AbstractWmlConversionContext)conversionContext)) {
            this.appendPartContent(conversionContext, document, currentParent, "xsl-region-after-firstpage", (Part)sectionWrapper.getHeaderFooterPolicy().getFirstFooter(), ((Ftr)sectionWrapper.getHeaderFooterPolicy().getFirstFooter().getJaxbElement()).getContent());
        }
        if (XsltCommonFunctions.hasEvenHeader((AbstractWmlConversionContext)conversionContext)) {
            this.appendPartContent(conversionContext, document, currentParent, "xsl-region-before-evenpage", (Part)sectionWrapper.getHeaderFooterPolicy().getEvenHeader(), ((Hdr)sectionWrapper.getHeaderFooterPolicy().getEvenHeader().getJaxbElement()).getContent());
        }
        if (XsltCommonFunctions.hasEvenFooter((AbstractWmlConversionContext)conversionContext)) {
            this.appendPartContent(conversionContext, document, currentParent, "xsl-region-after-evenpage", (Part)sectionWrapper.getHeaderFooterPolicy().getEvenFooter(), ((Ftr)sectionWrapper.getHeaderFooterPolicy().getEvenFooter().getJaxbElement()).getContent());
        }
        if (XsltCommonFunctions.hasDefaultHeader((AbstractWmlConversionContext)conversionContext)) {
            this.appendPartContent(conversionContext, document, currentParent, "xsl-region-before-default", (Part)sectionWrapper.getHeaderFooterPolicy().getDefaultHeader(), ((Hdr)sectionWrapper.getHeaderFooterPolicy().getDefaultHeader().getJaxbElement()).getContent());
        }
        if (XsltCommonFunctions.hasDefaultFooter((AbstractWmlConversionContext)conversionContext)) {
            this.appendPartContent(conversionContext, document, currentParent, "xsl-region-after-default", (Part)sectionWrapper.getHeaderFooterPolicy().getDefaultFooter(), ((Ftr)sectionWrapper.getHeaderFooterPolicy().getDefaultFooter().getJaxbElement()).getContent());
        }
    }

    protected void appendPartContent(FOConversionContext conversionContext, Document document, Element currentParent, String name, Part part, List<Object> content) throws Docx4JException {
        Element flow = document.createElementNS(XSL_FO, "static-content");
        currentParent.appendChild(flow);
        flow.setAttribute("flow-name", name);
        this.appendPartContent(conversionContext, document, part, content, flow);
    }

    protected Element createSectionBody(FOConversionContext conversionContext, Document document, ConversionSectionWrapper sectionWrapper, Element currentParent) throws Docx4JException {
        Element ret = document.createElementNS(XSL_FO, "flow");
        ret.setAttribute("flow-name", "xsl-region-body");
        return ret;
    }
}

