/*
 * Decompiled with CFR 0.152.
 */
package org.docstr.gradle.plugins.gwt;

import java.io.File;
import java.util.List;
import org.docstr.gradle.plugins.gwt.AbstractGwtActionTask;
import org.docstr.gradle.plugins.gwt.AbstractGwtCompile;
import org.docstr.gradle.plugins.gwt.AbstractGwtTask;
import org.docstr.gradle.plugins.gwt.GwtDev;
import org.docstr.gradle.plugins.gwt.GwtPluginExtension;
import org.docstr.gradle.plugins.gwt.GwtSuperDev;
import org.docstr.gradle.plugins.gwt.GwtTestExtension;
import org.docstr.gradle.plugins.gwt.GwtWarPlugin;
import org.docstr.gradle.plugins.gwt.LogLevel;
import org.docstr.gradle.plugins.gwt.internal.GwtVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.testing.Test;

public class GwtBasePlugin
implements Plugin<Project> {
    public static final String GWT_TASK_GROUP = "GWT";
    public static final String GWT_CONFIGURATION = "gwt";
    public static final String GWT_SDK_CONFIGURATION = "gwtSdk";
    public static final String EXTENSION_NAME = "gwt";
    public static final String BUILD_DIR = "gwt";
    public static final String WORK_DIR = "work";
    public static final String CACHE_DIR = "cache";
    public static final String LOG_DIR = "log";
    public static final String DEV_WAR = "war";
    public static final String TASK_GWT_SUPER_DEV = "gwtSuperDev";
    public static final String GWT_GROUP_GOOGLE = "com.google.gwt";
    public static final String GWT_GROUP_OSS = "org.gwtproject";
    public static final String GWT_DEV = "gwt-dev";
    public static final String GWT_USER = "gwt-user";
    public static final String GWT_CODESERVER = "gwt-codeserver";
    public static final String GWT_ELEMENTAL = "gwt-elemental";
    public static final String GWT_SERVLET = "gwt-servlet";
    private static final String TARGET_CONFIGURATION = "compileOnly";
    private static final Logger logger = Logging.getLogger(GwtBasePlugin.class);
    private Project project;
    private GwtPluginExtension extension;
    private Configuration gwtConfiguration;
    private Configuration gwtSdkConfiguration;
    private ConfigurableFileCollection allGwtConfigurations;

    public void apply(Project project) {
        this.project = project;
        project.getPlugins().apply(JavaPlugin.class);
        File gwtBuildDir = new File(project.getBuildDir(), "gwt");
        this.extension = this.configureGwtExtension(gwtBuildDir);
        this.configureAbstractActionTasks();
        this.configureAbstractTasks();
        this.configureGwtCompile();
        this.configureGwtDev();
        this.configureGwtSuperDev();
        this.gwtConfiguration = ((Configuration)project.getConfigurations().create("gwt")).setDescription("Classpath for GWT client libraries that are not included in the war");
        this.gwtSdkConfiguration = ((Configuration)project.getConfigurations().create(GWT_SDK_CONFIGURATION)).setDescription("Classpath for GWT SDK libraries (gwt-dev, gwt-user)");
        this.allGwtConfigurations = project.files(new Object[]{this.gwtConfiguration, this.gwtSdkConfiguration});
        project.getConfigurations().getByName(TARGET_CONFIGURATION).extendsFrom(new Configuration[]{this.gwtConfiguration, this.gwtSdkConfiguration});
        project.afterEvaluate(p -> {
            GwtVersion parsedGwtVersion;
            SourceSet testSourceSet = this.getTestSourceSet();
            testSourceSet.setRuntimeClasspath(testSourceSet.getRuntimeClasspath().plus((FileCollection)project.files(this.getMainSourceSet().getAllJava().getSrcDirs().toArray())).plus((FileCollection)project.files(this.getTestSourceSet().getAllJava().getSrcDirs().toArray())));
            if (this.extension.getTest().isHasGwtTests()) {
                this.configureTestTasks(this.extension);
            }
            if (((parsedGwtVersion = GwtVersion.parse(this.extension.getGwtVersion())) == null || parsedGwtVersion.isAtLeast(2, 5)) && this.extension.isCodeserver()) {
                this.createSuperDevModeTask(project);
            }
            if (parsedGwtVersion == null) {
                logger.debug("No automatic adding of GWT dependencies because gwtVersion is null or empty.");
            } else {
                project.getDependencies().add(GWT_SDK_CONFIGURATION, (Object)this.gwtDependency(GWT_DEV, parsedGwtVersion));
                project.getDependencies().add(GWT_SDK_CONFIGURATION, (Object)this.gwtDependency(GWT_USER, parsedGwtVersion));
                project.getDependencies().add("runtimeOnly", (Object)this.gwtDependency(GWT_SERVLET, parsedGwtVersion));
                if (parsedGwtVersion.isAtLeast(2, 5)) {
                    if (this.extension.isCodeserver()) {
                        project.getDependencies().add("gwt", (Object)this.gwtDependency(GWT_CODESERVER, parsedGwtVersion));
                    }
                    if (this.extension.isElemental()) {
                        project.getDependencies().add("gwt", (Object)this.gwtDependency(GWT_ELEMENTAL, parsedGwtVersion));
                    }
                } else {
                    logger.warn("GWT version is < 2.5 -> additional dependencies are not added.");
                }
            }
        });
    }

    private String gwtDependency(String artifactId, GwtVersion gwtVersion) {
        String group = gwtVersion.isAtLeast(2, 10) ? GWT_GROUP_OSS : GWT_GROUP_GOOGLE;
        return String.format("%s:%s:%s", group, artifactId, gwtVersion);
    }

    private GwtPluginExtension configureGwtExtension(File buildDir) {
        GwtPluginExtension extension = (GwtPluginExtension)this.project.getExtensions().create("gwt", GwtPluginExtension.class, new Object[0]);
        extension.setDevWar(this.project.file((Object)DEV_WAR));
        extension.setWorkDir(new File(buildDir, WORK_DIR));
        extension.setCacheDir(new File(buildDir, CACHE_DIR));
        extension.getDev().setLogDir(new File(buildDir, LOG_DIR));
        extension.getCompiler().setLocalWorkers(Runtime.getRuntime().availableProcessors());
        extension.setLogLevel(this.getLogLevel());
        extension.getSuperDev().setUseClasspathForSrc(true);
        ConventionMapping conventionMapping = ((IConventionAware)extension).getConventionMapping();
        conventionMapping.map("src", () -> {
            SourceSet mainSourceSet = this.getMainSourceSet();
            return this.project.files(new Object[]{mainSourceSet.getAllJava().getSrcDirs()}).plus((FileCollection)this.project.files(new Object[]{mainSourceSet.getOutput().getResourcesDir()}));
        });
        return extension;
    }

    private void createSuperDevModeTask(Project project) {
        project.getTasks().register(TASK_GWT_SUPER_DEV, GwtSuperDev.class, task -> {
            task.dependsOn(new Object[]{project.getTasks().named("compileJava"), project.getTasks().named("processResources")});
            task.setDescription("Runs the GWT super dev mode");
        });
    }

    private void configureAbstractTasks() {
        this.project.getTasks().withType(AbstractGwtTask.class).configureEach(task -> {
            ConventionMapping conventionMapping = ((IConventionAware)task).getConventionMapping();
            conventionMapping.map("extra", () -> this.extension.getExtraDir());
            conventionMapping.map("workDir", () -> this.extension.getWorkDir());
            conventionMapping.map("gen", () -> this.extension.getGenDir());
            conventionMapping.map("cacheDir", () -> this.extension.getCacheDir());
            conventionMapping.map("logLevel", () -> this.extension.getLogLevel());
        });
    }

    private void configureAbstractActionTasks() {
        JavaPluginConvention javaConvention = this.getJavaConvention();
        SourceSet mainSourceSet = (SourceSet)javaConvention.getSourceSets().getByName("main");
        this.project.getTasks().withType(AbstractGwtActionTask.class).configureEach(task -> {
            task.setGroup(GWT_TASK_GROUP);
            ConventionMapping conventionMapping = ((IConventionAware)task).getConventionMapping();
            conventionMapping.map("gwtVersion", () -> this.extension.getGwtVersion());
            conventionMapping.map("modules", () -> {
                List<String> devModules = this.extension.getDevModules();
                if (task.isDevTask() && devModules != null && !devModules.isEmpty()) {
                    return devModules;
                }
                return this.extension.getModules();
            });
            conventionMapping.map("src", () -> this.extension.getSrc());
            conventionMapping.map("classpath", () -> mainSourceSet.getCompileClasspath().plus((FileCollection)this.project.files(new Object[]{mainSourceSet.getOutput().getClassesDirs()})).plus((FileCollection)this.project.files(new Object[]{this.gwtConfiguration})).plus((FileCollection)this.project.files(new Object[]{this.gwtSdkConfiguration})));
            conventionMapping.map("minHeapSize", () -> this.extension.getMinHeapSize());
            conventionMapping.map("maxHeapSize", () -> this.extension.getMaxHeapSize());
            conventionMapping.map("extraJvmArgs", () -> this.extension.getExtraJvmArgs());
            conventionMapping.map("sourceLevel", () -> this.extension.getSourceLevel());
            conventionMapping.map("incremental", () -> this.extension.getIncremental());
            conventionMapping.map("jsInteropMode", () -> this.extension.getJsInteropMode());
            conventionMapping.map("jsInteropExports", this.extension::getJsInteropExports);
            conventionMapping.map("methodNameDisplayMode", this.extension::getMethodNameDisplayMode);
        });
    }

    private void configureGwtCompile() {
        this.project.getTasks().withType(AbstractGwtCompile.class).configureEach(task -> task.configure(this.extension.getCompiler()));
    }

    private void configureGwtDev() {
        boolean debug = "true".equals(System.getProperty("gwtDev.debug"));
        this.project.getTasks().withType(GwtDev.class).configureEach(task -> {
            task.configure(this.extension);
            task.setDebug(debug);
        });
    }

    private void configureGwtSuperDev() {
        this.project.getTasks().withType(GwtSuperDev.class).configureEach(task -> {
            task.configure(this.extension.getSuperDev());
            ConventionMapping conventionMapping = ((IConventionAware)task).getConventionMapping();
            conventionMapping.map("workDir", () -> this.extension.getWorkDir());
        });
    }

    private void configureTestTasks(GwtPluginExtension gwtPluginExtension) {
        this.project.getTasks().withType(Test.class, testTask -> {
            testTask.getTestLogging().setShowStandardStreams(true);
            GwtTestExtension testExtension = (GwtTestExtension)testTask.getExtensions().create("gwt", GwtTestExtension.class, new Object[0]);
            testExtension.configure(gwtPluginExtension, (IConventionAware)testExtension);
            this.project.afterEvaluate(p -> {
                String gwtArgs = testExtension.getParameterString();
                testTask.systemProperty("gwt.args", (Object)gwtArgs);
                logger.info("Using gwt.args for test: " + gwtArgs);
                if (testExtension.getCacheDir() != null) {
                    testTask.systemProperty("gwt.persistentunitcachedir", (Object)testExtension.getCacheDir());
                    testExtension.getCacheDir().mkdirs();
                    logger.info("Using gwt.persistentunitcachedir for test: {0}", (Object)testExtension.getCacheDir());
                }
            });
            this.project.getPlugins().withType(GwtWarPlugin.class, plugin -> testTask.dependsOn(new Object[]{this.project.getTasks().named("warTemplate")}));
        });
    }

    private LogLevel getLogLevel() {
        if (logger.isTraceEnabled()) {
            return LogLevel.TRACE;
        }
        if (logger.isDebugEnabled()) {
            return LogLevel.DEBUG;
        }
        if (logger.isInfoEnabled()) {
            return LogLevel.INFO;
        }
        if (logger.isLifecycleEnabled() || logger.isWarnEnabled()) {
            return LogLevel.WARN;
        }
        return LogLevel.ERROR;
    }

    private SourceSet getMainSourceSet() {
        return (SourceSet)this.getJavaConvention().getSourceSets().getByName("main");
    }

    private SourceSet getTestSourceSet() {
        return (SourceSet)this.getJavaConvention().getSourceSets().getByName("test");
    }

    private JavaPluginConvention getJavaConvention() {
        return (JavaPluginConvention)this.project.getConvention().getPlugin(JavaPluginConvention.class);
    }

    GwtPluginExtension getExtension() {
        return this.extension;
    }

    Configuration getGwtConfiguration() {
        return this.gwtConfiguration;
    }

    Configuration getGwtSdkConfiguration() {
        return this.gwtSdkConfiguration;
    }

    ConfigurableFileCollection getAllGwtConfigurations() {
        return this.allGwtConfigurations;
    }
}

