/*
 * Decompiled with CFR 0.152.
 */
package org.docshare.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Properties;
import org.docshare.log.Log;
import org.docshare.mvc.Config;

public class PropLoader {
    static final String PROP_FILE = "/last.properties";

    public static void setField(Field f, Object obj, String var) {
        try {
            Log.d("set " + f.getName() + " to " + var);
            Class<?> type = f.getType();
            if (type == Integer.TYPE) {
                f.set(null, Integer.parseInt(var));
            } else if (type == Float.TYPE) {
                f.set(null, Float.valueOf(Float.parseFloat(var)));
            } else if (type == Double.TYPE) {
                f.set(null, Double.parseDouble(var));
            } else if (type == Boolean.TYPE) {
                f.set(null, Boolean.parseBoolean(var));
            } else if (type == String.class) {
                f.set(null, var);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static void loadToStatic(String fileName, Class<?> clazz) {
        Field[] fields;
        Properties prop = PropLoader.loadProp(fileName);
        for (Field f : fields = clazz.getFields()) {
            String name = f.getName();
            Object obj = prop.get(name);
            if (obj == null) continue;
            String var = obj.toString();
            PropLoader.setField(f, null, var);
        }
    }

    public static void main(String[] args) {
        PropLoader.loadToStatic(PROP_FILE, Config.class);
        Log.i((Object)Config.str());
    }

    private static Properties loadProp(String fileName) {
        try {
            URL purl = PropLoader.class.getResource(PROP_FILE);
            Log.d("read prop from " + purl);
            Log.d("class loader name " + PropLoader.class.getClassLoader().toString());
            if (purl == null) {
                Log.e("Config file NOT found : " + fileName);
            } else {
                Log.i((Object)"Config file found ! ");
            }
            Properties pro = new Properties();
            InputStream in = null;
            in = PropLoader.class.getResourceAsStream(PROP_FILE);
            if (in != null) {
                pro.load(in);
                Log.i((Object)(fileName + " loaded "));
                in.close();
            } else {
                Log.i((Object)(fileName + " NOT load "));
            }
            return pro;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

