/*
 * Decompiled with CFR 0.152.
 */
package org.docshare.orm.postgres;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.docshare.log.Log;
import org.docshare.mvc.except.MVCException;
import org.docshare.orm.ArrayTool;
import org.docshare.orm.ColumnDesc;
import org.docshare.orm.DBHelper;
import org.docshare.orm.DBTool;
import org.docshare.orm.IDBDelegate;
import org.docshare.orm.Model;
import org.docshare.orm.SQLConstains;
import org.docshare.util.TextTool;

public class PostgresDelegate
implements IDBDelegate {
    public Map<String, ColumnDesc> c_to_remarks;

    @Override
    public ResultSet resultById(String tname, String column, Object id) throws SQLException {
        ResultSet rs = DBHelper.getIns().getPrepareRS(String.format("select * from \"%s\" where \"%s\" = ? limit 1", tname, column), id);
        return rs;
    }

    @Override
    public int save(DBTool tool, Model m, String key, boolean forceInsert) {
        if (m == null) {
            Log.e("can not save a null object");
            return 0;
        }
        Object id = m.get(key);
        String sql = "";
        ArrayList<Object> plist = new ArrayList<Object>();
        if (forceInsert || m.isCreated || id == null || id instanceof Integer && (Integer)id <= 0) {
            String ks = "";
            Object vs2 = "";
            boolean first = true;
            for (String k : m.keySet()) {
                Object v;
                if (k.equals(key)) {
                    // empty if block
                }
                if ((v = m.get(k)) == null || v.toString().length() == 0) continue;
                if (!first) {
                    ks = ks + ',';
                    vs2 = (String)vs2 + ",";
                }
                ks = ks + "\"" + k + "\"";
                String type = tool.getColumnTypeName(k);
                ArrayTool.valueWrapper(null, v, type);
                vs2 = (String)vs2 + "?";
                plist.add(v);
                first = false;
            }
            sql = String.format("insert into \"%s\"(%s) values(%s)", m.getTableName(), ks, vs2);
        } else {
            ArrayList<String> sa = new ArrayList<String>();
            for (String k : m.changeColumns()) {
                Object v;
                if (k == key || (v = m.get(k)) == null || v.toString().length() == 0) continue;
                String type = tool.getColumnTypeName(k);
                ArrayTool.valueWrapper(k, m.get(k), type);
                sa.add("\"" + k + "\"=?");
                plist.add(m.get(k));
            }
            String ss = ArrayTool.join(",", sa);
            sql = String.format("update \"%s\" set %s where %s", m.getTableName(), ss, ArrayTool.valueWrapper(key, id, tool.getColumnTypeName("id")));
            if (m.changeColumns().size() == 0) {
                Log.i((Object)("no change data for update " + sql));
                return 0;
            }
        }
        Log.d("DBTool run sql: " + sql + "  params=[" + ArrayTool.joinWithLengthLimit(",", plist, 20) + "]");
        Object[] objs = plist.toArray();
        DBHelper helper = DBHelper.getIns("postgres");
        int d = helper.updateWithArray(sql, objs);
        Log.d("return " + d);
        if (d != 0 && (id == null || forceInsert)) {
            id = helper.getLastId();
            m.put(key, id);
        }
        return d;
    }

    @Override
    public int delete(String tname, String key, Object id) {
        String sql = String.format("delete from \"%s\" where \"%s\" = ?", tname, key);
        Log.d("DBTool run sql: " + sql + " ,param  = " + id);
        return DBHelper.getIns().update(sql, id);
    }

    public ResultSet runSQL(List<SQLConstains> cons, DBTool tool, String tbName) {
        return this.runSQL(cons, null, null, tool, tbName, "*");
    }

    @Override
    public long size(List<SQLConstains> cons, DBTool tool, String tbName) {
        try {
            ResultSet rs = this.runSQL(cons, null, null, tool, tbName, "count(*) as CT");
            if (rs.next()) {
                long id = rs.getLong("CT");
                rs.close();
                return id;
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new MVCException("get size error: ", e);
        }
        return 0L;
    }

    @Override
    public ResultSet runSQL(List<SQLConstains> cons, SQLConstains orderc, SQLConstains limitc, DBTool tool, String tbName, String prefix) {
        String sql;
        if (tbName == null) {
            return null;
        }
        ArrayList<String> sa = new ArrayList<String>();
        ArrayList<Object> params = new ArrayList<Object>();
        String[] fh = new String[]{"", "=", ">", "<", ">=", "<=", "<>"};
        block11: for (SQLConstains c : cons) {
            if (c.type < fh.length) {
                sa.add(String.format("\"%s\" %s ?", c.column, fh[c.type]));
                params.add(c.value);
                continue;
            }
            switch (c.type) {
                case 7: {
                    String w = String.format("  \"%s\" like ? ", c.column);
                    sa.add(w);
                    params.add("%" + c.value + "%");
                    continue block11;
                }
                case 8: {
                    String[] ca = c.column.split(",");
                    String t = "(" + String.format("\"%s\" like ?", ca[0]);
                    params.add("%" + c.value + "%");
                    for (int i = 1; i < ca.length; ++i) {
                        t = t + " or " + String.format("\"%s\" like ?", ca[i]);
                        params.add("%" + c.value + "%");
                    }
                    t = t + ")";
                    sa.add(t);
                    continue block11;
                }
                case 100: {
                    limitc = c;
                    continue block11;
                }
                case 50: {
                    orderc = c;
                    continue block11;
                }
                case 200: {
                    sa.add(c.column);
                    continue block11;
                }
            }
            Log.e("unsupport type" + c.type);
        }
        String tail = "";
        if (orderc != null) {
            tail = tail + String.format(" order by \"%s\" %s", orderc.column, (Boolean)orderc.value != false ? "asc" : "desc");
        }
        if (limitc != null) {
            tail = tail + " limit ?,?";
            params.add(limitc.value);
            params.add(limitc.value2);
        }
        DBHelper helper = DBHelper.getIns("postgres");
        String c = TextTool.join2(sa, " and ") + tail;
        if (c.trim().length() == 0) {
            sql = "select " + prefix + " from \"" + tbName + "\"";
            try {
                return helper.getRS(sql);
            }
            catch (SQLException e) {
                throw new MVCException("runSQL error: [ " + sql + " ]", e);
            }
        }
        c = !(c = c.trim()).startsWith("limit") && !c.startsWith("order") ? " where " + c : " " + c;
        sql = "select " + prefix + " from \"" + tbName + "\" " + c;
        try {
            return helper.getRS(sql, params);
        }
        catch (SQLException e) {
            throw new MVCException("runSQL error: [ " + sql + " ]", e);
        }
    }

    @Override
    public ResultSet runSQL(String rawSql) throws SQLException {
        return DBHelper.getIns().getRS(rawSql);
    }

    @Override
    public Map<String, ColumnDesc> columnOfRs(String sql, ResultSet rs) {
        return DBHelper.getIns().columeOfRs(sql, rs);
    }

    @Override
    public Map<String, ColumnDesc> listColumn(String tname, boolean useCache) {
        return DBHelper.getIns().listColumn(tname, useCache);
    }

    @Override
    public String keyColumn(String tname) {
        return DBHelper.getIns().keyColumn(tname);
    }

    @Override
    public void beginTransaction() {
        DBHelper.getIns().beginTransation();
    }

    @Override
    public void commit() {
        DBHelper.getIns().commit();
    }

    @Override
    public void rollback() {
        DBHelper.getIns().rollback();
    }
}

