/*
 * Decompiled with CFR 0.152.
 */
package org.docshare.orm.mysql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.docshare.log.Log;
import org.docshare.mvc.except.MVCException;
import org.docshare.orm.ArrayTool;
import org.docshare.orm.ColumnDesc;
import org.docshare.orm.DBHelper;
import org.docshare.orm.DBTool;
import org.docshare.orm.IDBDelegate;
import org.docshare.orm.Model;
import org.docshare.orm.SQLConstains;

public class MySQLDelegate
implements IDBDelegate {
    public Map<String, ColumnDesc> c_to_remarks;

    @Override
    public ResultSet resultById(String tname, String column, Object id) throws SQLException {
        StringBuilder sBuffer = new StringBuilder();
        sBuffer.append("select * from `");
        sBuffer.append(tname);
        sBuffer.append("` where `");
        sBuffer.append(column);
        sBuffer.append("` = ? limit 0,1");
        ResultSet rs = DBHelper.getIns().getPrepareRS(sBuffer.toString(), id);
        return rs;
    }

    @Override
    public int save(DBTool tool, Model m, String key, boolean forceInsert) {
        if (m == null) {
            Log.e("can not save a null object");
            return 0;
        }
        Object id = m.get(key);
        String sql = "";
        ArrayList<Object> plist = new ArrayList<Object>(8);
        if (forceInsert || m.isCreated || id == null || id instanceof Integer && (Integer)id <= 0) {
            StringBuilder ks = new StringBuilder();
            StringBuilder vs2 = new StringBuilder();
            boolean first = true;
            for (String k : m.keySet()) {
                Object v;
                if (k.equals(key)) {
                    // empty if block
                }
                if ((v = m.get(k)) == null) continue;
                if (!first) {
                    ks.append(',');
                    vs2.append(',');
                }
                ks.append('`');
                ks.append(k);
                ks.append('`');
                String type = tool.getColumnTypeName(k);
                ArrayTool.valueWrapper(null, v, type);
                vs2.append('?');
                plist.add(v);
                first = false;
            }
            StringBuilder sqlb = new StringBuilder();
            sqlb.append("insert into `");
            sqlb.append(m.getTableName());
            sqlb.append("`(");
            sqlb.append((CharSequence)ks);
            sqlb.append(") values(");
            sqlb.append((CharSequence)vs2);
            sqlb.append(")");
            sql = sqlb.toString();
        } else {
            int csize = m.changeColumns().size();
            if (csize == 0) {
                Log.i((Object)("no change data for update " + sql));
                return 0;
            }
            ArrayList<String> sa = new ArrayList<String>(csize);
            for (String k : m.changeColumns()) {
                Object v;
                if (k == key || (v = m.get(k)) == null) continue;
                sa.add("`" + k + "`=?");
                plist.add(m.get(k));
            }
            String ss = ArrayTool.join(",", sa);
            StringBuilder sqlb = new StringBuilder();
            sqlb.append("update `");
            sqlb.append(m.getTableName());
            sqlb.append("` set ");
            sqlb.append(ss);
            sqlb.append(" where ");
            sqlb.append(ArrayTool.valueWrapper(key, id, tool.getColumnTypeName(key)));
            sql = sqlb.toString();
        }
        Log.d("DBTool run sql: " + sql + "  params=[" + ArrayTool.joinWithLengthLimit(",", plist, 20) + "]");
        Object[] objs = plist.toArray();
        DBHelper helper = DBHelper.getIns("mysql");
        int d = helper.updateWithArray(sql, objs);
        Log.d("return " + d);
        if (d != 0 && (id == null || forceInsert)) {
            id = helper.getLastId();
            m.put(key, id);
        }
        return d;
    }

    @Override
    public int delete(String tname, String key, Object id) {
        StringBuilder sBuffer = new StringBuilder();
        sBuffer.append("delete from `");
        sBuffer.append(tname).append("` where `").append(key).append("` = ?");
        String sql = sBuffer.toString();
        Log.d("DBTool run sql: " + sql + " ,param  = " + id);
        return DBHelper.getIns().update(sql, id);
    }

    @Override
    public long size(List<SQLConstains> cons, DBTool tool, String tbName) {
        try {
            ResultSet rs = this.runSQL(cons, null, null, tool, tbName, "count(*) as CT");
            if (rs != null) {
                if (rs.next()) {
                    long id = rs.getLong("CT");
                    rs.close();
                    return id;
                }
                rs.close();
            }
        }
        catch (SQLException e) {
            throw new MVCException("size: get size of query error", e);
        }
        return 0L;
    }

    @Override
    public ResultSet runSQL(List<SQLConstains> cons, SQLConstains order_con, SQLConstains limit_con, DBTool tool, String tbName, String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append("select ").append(prefix).append(" from `").append(tbName).append("` ");
        String[] fh = new String[]{"", "=", ">", "<", ">=", "<=", "<>"};
        ArrayList<Object> params = new ArrayList<Object>();
        if (cons.size() > 0) {
            sb.append("where ");
            boolean first = true;
            block8: for (SQLConstains c : cons) {
                if (!first) {
                    sb.append(" and ");
                }
                first = false;
                if (c.type < fh.length) {
                    sb.append("`").append(c.column).append("` ").append(fh[c.type]).append(" ?");
                    params.add(c.value);
                    continue;
                }
                switch (c.type) {
                    case 9: {
                        sb.append(" `").append(c.column).append("` is NULL ");
                        continue block8;
                    }
                    case 7: {
                        sb.append(" `").append(c.column).append("` like ? ");
                        params.add("%" + c.value + "%");
                        continue block8;
                    }
                    case 8: {
                        String[] ca = c.column.split(",");
                        sb.append("(`").append(ca[0]).append("` like ?");
                        params.add("%" + c.value + "%");
                        for (int i = 1; i < ca.length; ++i) {
                            sb.append(" or `").append(ca[i]).append("` like ?");
                            params.add("%" + c.value + "%");
                        }
                        sb.append(") ");
                        continue block8;
                    }
                    case 200: {
                        sb.append(' ');
                        sb.append(c.column);
                        sb.append(' ');
                        continue block8;
                    }
                }
                Log.e("unsupport type" + c.type);
            }
        }
        if (order_con != null) {
            sb.append(" order by `").append(order_con.column).append("` ").append((Boolean)order_con.value != false ? "asc " : "desc ");
        }
        if (limit_con != null) {
            sb.append(" limit ?,?");
            params.add(limit_con.value);
            params.add(limit_con.value2);
        }
        String sql = sb.toString();
        try {
            DBHelper helper = DBHelper.getIns("mysql");
            return helper.getRS(sql, params);
        }
        catch (SQLException e) {
            throw new MVCException("runSQL error: [ " + sql + " ]", e);
        }
    }

    @Override
    public ResultSet runSQL(String rawSql) throws SQLException {
        return DBHelper.getIns().getRS(rawSql);
    }

    @Override
    public Map<String, ColumnDesc> columnOfRs(String sql, ResultSet rs) {
        return DBHelper.getIns().columeOfRs(sql, rs);
    }

    @Override
    public Map<String, ColumnDesc> listColumn(String tname, boolean useCache) {
        return DBHelper.getIns().listColumn(tname, useCache);
    }

    @Override
    public String keyColumn(String tname) {
        return DBHelper.getIns().keyColumn(tname);
    }

    @Override
    public void beginTransaction() {
        DBHelper.getIns().beginTransation();
    }

    @Override
    public void commit() {
        DBHelper.getIns().commit();
    }

    @Override
    public void rollback() {
        DBHelper.getIns().rollback();
    }
}

