/*
 * Decompiled with CFR 0.152.
 */
package org.docshare.orm.mysql;

import com.alibaba.fastjson.JSON;
import com.mysql.cj.jdbc.exceptions.CommunicationsException;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import org.docshare.log.Log;
import org.docshare.mvc.Config;
import org.docshare.mvc.except.MVCException;
import org.docshare.orm.ColumnDesc;
import org.docshare.orm.DBHelper;
import org.docshare.orm.StatementPool;
import org.docshare.util.FileTool;
import org.docshare.util.TextTool;

public class MySQLDBHelper
extends DBHelper {
    StatementPool statementPool = new StatementPool();

    @Override
    public void conn() {
        String uri = null;
        try {
            if (this.con != null && !this.con.isClosed() && this.con.isValid(5)) {
                return;
            }
            this.statementPool.clear();
            Log.d("MySQLDBHelper connect to server");
            Class.forName("com.mysql.cj.jdbc.Driver");
            String encoding = Config.dbEncoding;
            if (encoding.contains("utf8")) {
                encoding = "utf8";
            }
            uri = TextTool.concat("jdbc:mysql://", Config.dbhost, ":", Config.dbport, "/", Config.dbname, "?characterEncoding=", encoding, "&useSSL=", Config.useSSL, "&serverTimezone=Asia/Shanghai").toString();
            this.con = DriverManager.getConnection(uri, Config.dbusr, Config.dbpwd);
            this.update("set names " + Config.dbEncoding, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            Log.e(e);
        }
        catch (SQLException e) {
            Log.e(e);
            Log.e(Config.str());
            throw new MVCException("connect to url fail: " + uri, e);
        }
    }

    public static void main(String[] args) throws SQLException {
        Config.dbport = "3308";
        Config.dbname = "mvc_demo";
        DBHelper helper = DBHelper.getIns();
        helper.conn();
        System.out.println(helper.keyColumn("book"));
        ResultSet rs = helper.getRS("select * from book");
        while (rs.next()) {
            String s = rs.getString("name");
            System.out.println(s);
        }
        HashMap<String, ColumnDesc> cc = helper.columeOfRs("select * from book", rs);
        System.out.println(JSON.toJSONString(cc));
        cc = helper.listColumn("book");
        System.out.println(JSON.toJSONString(cc));
        String key = helper.keyColumn("book");
        System.out.println(key);
        cc = helper.listColumn("catalog");
        System.out.println(JSON.toJSONString(cc));
        rs.close();
    }

    @Override
    public ResultSet getRS(String sql, List<Object> params) throws SQLException {
        this.printParams(sql, params);
        if (this.con == null || this.con.isClosed()) {
            this.conn();
        }
        int retry = 0;
        while (retry < 3) {
            try {
                PreparedStatement s = this.statementPool.get(this.con, sql);
                for (int i = 0; i < params.size(); ++i) {
                    s.setObject(i + 1, params.get(i));
                }
                return s.executeQuery();
            }
            catch (CommunicationsException e) {
                Log.i((Object)("reconnect db retry=" + ++retry));
                this.conn();
            }
        }
        throw new SQLException("DB Connection is lost ,but can not reconnect ! ");
    }

    /*
     * Loose catch block
     */
    @Override
    public int updateWithArray(String sql, Object[] objs) {
        if (this.con == null) {
            this.conn();
        }
        int retry = 0;
        ResultSet last = null;
        while (retry < 3) {
            try {
                this.last_id = -1;
                PreparedStatement s = this.statementPool.get(this.con, sql);
                if (objs != null) {
                    for (int i = 0; i < objs.length; ++i) {
                        s.setObject(i + 1, objs[i]);
                    }
                }
                int ret = s.executeUpdate();
                last = s.getGeneratedKeys();
                this.last_id = last != null && last.next() ? last.getObject(1) : Integer.valueOf(-1);
                last.close();
                int n = ret;
                FileTool.safelyClose(last);
                return n;
            }
            catch (CommunicationsException e) {
                Log.i((Object)("reconnect db retry=" + ++retry));
                this.conn();
            }
            catch (SQLException e2) {
                throw new MVCException(e2);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                FileTool.safelyClose(last);
            }
        }
        return -1;
    }
}

