/*
 * Decompiled with CFR 0.152.
 */
package org.docshare.orm;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.docshare.log.Log;
import org.docshare.mvc.Controller;
import org.docshare.orm.ColumnDesc;
import org.docshare.orm.DBTool;
import org.docshare.util.BeanUtil;
import org.docshare.util.TextTool;
import org.jetbrains.annotations.NotNull;

public class Model
implements Map<String, Object> {
    private String tname;
    public boolean isNull = false;
    private Map<String, Object> columns;
    private Map<String, Object> extra;
    DBTool joined_tool = null;
    public boolean isCreated = false;
    HashSet<String> changeList = null;

    protected Model(String tname, Map<String, Object> columns) {
        this.tname = tname;
        this.columns = new HashMap<String, Object>();
        if (columns != null) {
            this.columns.putAll(columns);
        }
    }

    public static DBTool tool(String tname) {
        return DBTool.getIns(tname);
    }

    public String getTableName() {
        return this.tname;
    }

    public String remark(String c) {
        String r = this.joined_tool.getColumnRemark(c);
        return r == null ? c : r;
    }

    @Override
    public Set<String> keySet() {
        return this.columns.keySet();
    }

    @Override
    public int size() {
        if (this.columns == null) {
            return 0;
        }
        return this.columns.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.columns.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return false;
    }

    public String getStr(Object key) {
        Object rObject = this.get(key);
        return rObject == null ? null : rObject.toString();
    }

    public Integer getInt(Object key) {
        Object rObject = this.get(key);
        if (rObject instanceof Integer) {
            return (Integer)rObject;
        }
        String str = rObject + "";
        return Integer.parseInt(str);
    }

    public Long getLong(Object key) {
        Object rObject = this.get(key);
        if (rObject instanceof Long) {
            return (Long)rObject;
        }
        String str = rObject + "";
        return Long.parseLong(str);
    }

    public Double getDouble(Object key) {
        Object rObject = this.get(key);
        if (rObject instanceof Double) {
            return (Double)rObject;
        }
        String str = rObject + "";
        return Double.parseDouble(str);
    }

    @Override
    public Object get(Object key) {
        String ks = (String)key;
        if (this.extra != null && this.extra.containsKey(ks)) {
            return this.extra.get(ks);
        }
        String k = null;
        if (this.columns.containsKey(key)) {
            return this.columns.get(key);
        }
        if (!this.columns.containsKey(key) && this.columns.containsKey(key + "_id")) {
            k = key + "_id";
        }
        if (ks.endsWith("__obj") && !this.columns.containsKey(ks) && !this.columns.containsKey(k = TextTool.getBefore(ks, "__obj"))) {
            return null;
        }
        if (k != null) {
            ColumnDesc desc = this.joined_tool.getColumnDesc(k);
            if (desc.pk_table == null) {
                return null;
            }
            DBTool tool = Model.tool(desc.pk_table);
            return tool.get(desc.pk_column, this.columns.get(k));
        }
        return null;
    }

    @Override
    public Object remove(Object key) {
        Object ret = null;
        if (this.extra != null) {
            this.extra.remove(key);
        }
        if (ret == null) {
            ret = this.columns.remove(key);
        }
        return ret;
    }

    @Override
    public void clear() {
        if (this.extra != null) {
            this.extra.clear();
        }
        this.columns.clear();
    }

    @Override
    public Collection values() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (String s : this.keySet()) {
            list.add(this.get(s));
        }
        return list;
    }

    @Override
    public Set entrySet() {
        ModelEntry en;
        HashSet<ModelEntry> s = new HashSet<ModelEntry>();
        for (String key : this.keySet()) {
            en = new ModelEntry(key, this.get(key));
            s.add(en);
        }
        if (this.extra != null) {
            for (String key : this.extra.keySet()) {
                en = new ModelEntry(key, this.extra.get(key));
                s.add(en);
            }
        }
        return s;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String k : this.columns.keySet()) {
            sb.append("," + k + "=" + this.columns.get(k));
        }
        if (this.extra != null) {
            sb.append(",extra=" + JSON.toJSONString(this.extra));
        }
        sb.append("]");
        sb.setCharAt(0, '[');
        sb.insert(0, "Model");
        return sb.toString();
    }

    public Set<String> changeColumns() {
        return this.changeList != null ? this.changeList : new HashSet<String>();
    }

    @Override
    @NotNull
    public Model put(String key, Object value) {
        if (this.columns.containsKey(key)) {
            this.columns.put(key, value);
            if (this.changeList == null) {
                this.changeList = new HashSet();
            }
            this.changeList.add(key);
        } else {
            if (this.extra == null) {
                this.extra = new HashMap<String, Object>();
            }
            this.extra.put(key, value);
        }
        return this;
    }

    Model innerPut(String key, Object value) {
        if (this.columns.containsKey(key)) {
            this.columns.put(key, value);
        } else {
            if (this.extra == null) {
                this.extra = new HashMap<String, Object>();
            }
            this.extra.put(key, value);
        }
        return this;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
    }

    public String key() {
        return this.joined_tool.key;
    }

    public <T> T toObject(T obj) {
        for (String key : this.keySet()) {
            try {
                BeanUtil.set(obj, key, this.get(key));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return obj;
    }

    public static Model fromObject(String tname, Object obj) {
        Model ret = Model.tool(tname).create();
        for (String key : ret.keySet()) {
            try {
                Object val = BeanUtil.get(obj, key);
                ret.put(key, val);
            }
            catch (Exception e) {
                Log.d("can't set model of property: " + key);
                Log.d(e);
            }
        }
        ret.isCreated = false;
        return ret;
    }

    public <T> T toObject(Class<T> clz) {
        try {
            T obj = clz.newInstance();
            for (String key : this.keySet()) {
                BeanUtil.set(obj, key, this.get(key));
            }
            if (this.extra != null) {
                for (String key : this.extra.keySet()) {
                    BeanUtil.set(obj, key, this.get(key));
                }
            }
            return obj;
        }
        catch (IllegalAccessException | InstantiationException e) {
            Log.e(e);
            return null;
        }
    }

    public int insert() {
        if (this.joined_tool == null) {
            Log.e("Model didn't connect to a tool ,can't save" + this);
            return 0;
        }
        return this.joined_tool.insert(this);
    }

    public int update() {
        if (this.joined_tool == null) {
            Log.e("Model didn't connect to a tool ,can't save" + this);
            return 0;
        }
        return this.joined_tool.save(this, false);
    }

    public void remove() {
        if (this.joined_tool == null) {
            Log.e("Model didn't connect to a tool ,can't save" + this);
            return;
        }
        this.joined_tool.del(this);
    }

    public DBTool myTool() {
        return this.joined_tool;
    }

    public int save() {
        if (this.joined_tool != null) {
            return this.joined_tool.save(this);
        }
        Log.e("Model ,join_tool is null " + this.toString());
        return 0;
    }

    public void dump() {
        Log.i((Object)this.toString());
    }

    public Model fromParam(Controller c) {
        c.paramToModel(this);
        return this;
    }

    class ModelEntry
    implements Map.Entry {
        private Object key;
        private Object val;

        public ModelEntry(Object key, Object val) {
            this.key = key;
            this.val = val;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.val;
        }

        public Object setValue(Object value) {
            this.val = value;
            return value;
        }
    }
}

