/*
 * Decompiled with CFR 0.152.
 */
package org.docshare.orm;

import com.alibaba.fastjson.JSON;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.docshare.log.Log;
import org.docshare.orm.ColumnDesc;
import org.docshare.orm.DBTool;
import org.docshare.orm.IDBDelegate;
import org.docshare.orm.ListAdapter;
import org.docshare.orm.Model;
import org.docshare.orm.SQLConstains;
import org.docshare.util.FileTool;
import org.jetbrains.annotations.NotNull;

public class LasyList
extends ListAdapter {
    private ArrayList<SQLConstains> cons = new ArrayList();
    private DBTool tool;
    private ResultSet rs = null;
    private IDBDelegate delegate;
    private String tbName;
    private String rawSql = null;
    HashMap<Integer, Model> row_maps = new HashMap();
    Map<String, ColumnDesc> column_desc = null;
    private String column_filter = "*";
    List<Model> arrList = null;
    int iterIndex = 0;
    private int _start = 0;
    private SQLConstains limit_constrain = null;
    private SQLConstains order_constrain = null;

    public DBTool getTool() {
        return this.tool;
    }

    private LasyList(String rawSql) {
        this.rawSql = rawSql;
        this.tool = Model.tool("rawsql");
        this.delegate = this.tool.getDelegate();
        this.toArrayList();
    }

    public LasyList(DBTool tool, String tbName) {
        this.tbName = tbName;
        this.tool = tool;
        this.delegate = tool.getDelegate();
    }

    @Override
    public int size() {
        Log.v("size() called");
        if (this.arrList != null) {
            return this.arrList.size();
        }
        return (int)this.delegate.size(this.cons, this.tool, this.tbName);
    }

    public boolean exist() {
        if (this.arrList != null) {
            return this.arrList.size() > 0;
        }
        return this.delegate.size(this.cons, this.tool, this.tbName) > 0L;
    }

    @Override
    public boolean isEmpty() {
        Log.d("isEmpty() called");
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        this.toArrayList();
        if (this.arrList == null) {
            return false;
        }
        return this.arrList.contains(o);
    }

    @Override
    public Model get(int index) {
        this.toArrayList();
        try {
            if (this.arrList == null || index >= this.arrList.size() || index < 0) {
                return null;
            }
            return this.arrList.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            Log.d(e);
            return null;
        }
    }

    public void printColumnDesc() {
        if (this.column_desc == null) {
            this.column_desc = this.tool.c_to_remarks;
        }
        for (String k : this.column_desc.keySet()) {
            System.out.println(k + ", " + this.column_desc.get(k));
        }
    }

    public LasyList columnFilter(String filter) {
        this.column_filter = filter;
        return this;
    }

    private void initRS() {
        if (this.rs == null) {
            try {
                if (this.tbName == null && this.rawSql != null) {
                    this.rs = this.delegate.runSQL(this.rawSql);
                    if (this.rs != null && (this.column_desc == null || this.column_desc.size() == 0)) {
                        this.column_desc = this.delegate.columnOfRs(this.rawSql, this.rs);
                    }
                    if (this.rs == null && this.column_desc == null) {
                        this.column_desc = new HashMap<String, ColumnDesc>();
                    }
                } else {
                    this.rs = this.delegate.runSQL(this.cons, this.order_constrain, this.limit_constrain, this.tool, this.tbName, this.column_filter);
                }
            }
            catch (SQLException e) {
                Log.e("LasyList.initRS ERROR: " + this.debugInfo());
                Log.e(e);
            }
        }
    }

    @Override
    public Iterator<Model> iterator() {
        this.arrList = this.toArrayList();
        this.iterIndex = 0;
        return new Iterator<Model>(){

            @Override
            public boolean hasNext() {
                if (LasyList.this.arrList == null) {
                    return false;
                }
                return LasyList.this.iterIndex < LasyList.this.arrList.size();
            }

            @Override
            public Model next() {
                if (LasyList.this.arrList == null || LasyList.this.iterIndex >= LasyList.this.arrList.size()) {
                    return null;
                }
                return LasyList.this.arrList.get(LasyList.this.iterIndex++);
            }

            @Override
            public void remove() {
            }
        };
    }

    public LasyList page(int pageno, int pageSize) {
        if (pageno == 0) {
            pageno = 1;
        }
        int start = (pageno - 1) * pageSize;
        this.limit(start, pageSize);
        return this;
    }

    @NotNull
    public LasyList limit(int start, int len) {
        this._start = start;
        this.limit_constrain = new SQLConstains(100, "", start, len);
        return this;
    }

    @NotNull
    public LasyList limit(int len) {
        return this.limit(0, len);
    }

    @NotNull
    public LasyList like(String column, String q) {
        this.cons.add(new SQLConstains(7, column, q));
        return this;
    }

    @NotNull
    public LasyList mlike(String columnList, String q) {
        this.cons.add(new SQLConstains(8, columnList, q));
        return this;
    }

    @NotNull
    public LasyList eq(String column, Object val) {
        this.cons.add(new SQLConstains(1, column, val));
        return this;
    }

    @NotNull
    public LasyList gt(String column, Object val) {
        this.cons.add(new SQLConstains(2, column, val));
        return this;
    }

    @NotNull
    public LasyList gte(String column, Object val) {
        this.cons.add(new SQLConstains(4, column, val));
        return this;
    }

    @NotNull
    public LasyList lt(String column, Object val) {
        this.cons.add(new SQLConstains(3, column, val));
        return this;
    }

    @NotNull
    public LasyList lte(String column, Object val) {
        this.cons.add(new SQLConstains(5, column, val));
        return this;
    }

    @NotNull
    public LasyList ne(String column, Object val) {
        this.cons.add(new SQLConstains(6, column, val));
        return this;
    }

    public LasyList isNull(String column) {
        this.cons.add(new SQLConstains(9, column, null));
        return this;
    }

    @NotNull
    public LasyList orderby(String column, boolean asc) {
        this.order_constrain = new SQLConstains(50, column, asc);
        return this;
    }

    @NotNull
    public LasyList custom(String any) {
        this.cons.add(new SQLConstains(200, any, null));
        return this;
    }

    public Model one() {
        this.limit(this._start, 1);
        Model model = this.get(0);
        this.closeRS();
        return model;
    }

    private void closeRS() {
        try {
            if (this.rs != null) {
                this.rs.close();
                this.rs = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        this.closeRS();
        super.finalize();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Model m : this) {
            sb.append(m);
        }
        sb.append("]");
        return sb.toString();
    }

    public LasyList byExample(Model m) {
        for (String k : m.keySet()) {
            Object v = m.get(k);
            if (v == null) continue;
            this.cons.add(new SQLConstains(1, k, v));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Model> toArrayList() {
        if (this.arrList != null) {
            return this.arrList;
        }
        this.initRS();
        MyArrayList mList = new MyArrayList();
        try {
            this.arrList = mList;
            HashSet<String> cs = null;
            if (this.column_filter != null && !"*".equals(this.column_filter)) {
                String[] ca = this.column_filter.split(",");
                cs = new HashSet<String>();
                for (String cc : ca) {
                    cs.add(cc);
                }
            }
            while (this.rs != null && this.rs.next()) {
                Model m = this.tool.db2Table(this.rs, this.column_desc, cs);
                mList.add(m);
            }
            if (this.rs == null) {
                this.debugInfo();
            }
        }
        catch (SQLException e) {
            Log.e("LasyList.toArrayList Exception " + this.debugInfo());
            Log.e(e);
        }
        finally {
            FileTool.safelyClose(this.rs);
        }
        return mList;
    }

    public String debugInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("LasyList[");
        sb.append("\n   SQLConstains=" + JSON.toJSONString(this.cons));
        sb.append("\n\ttable name = " + this.tbName);
        sb.append("\n   rawSQL=" + this.rawSql);
        sb.append("]");
        return sb.toString();
    }

    public <T> List<T> toArrayList(Class<T> clazz) {
        List<Model> models = this.toArrayList();
        ArrayList<T> ret = new ArrayList<T>();
        try {
            for (Model m : models) {
                ret.add(m.toObject(clazz.newInstance()));
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static LasyList fromRawSql(String sql) {
        LasyList list = new LasyList(sql);
        return list;
    }

    public LasyList each(Each fun) {
        for (Model m : this) {
            fun.one(m);
        }
        return this;
    }

    public List<Model> filter(Each fun) {
        ArrayList<Model> ret = new ArrayList<Model>();
        for (Model m : this) {
            if (!fun.one(m)) continue;
            ret.add(m);
        }
        return ret;
    }

    static class MyArrayList
    extends ArrayList<Model> {
        private static final long serialVersionUID = 7008979830534539859L;

        MyArrayList() {
        }

        public MyArrayList each(Each fun) {
            for (Model m : this) {
                fun.one(m);
            }
            return this;
        }

        public MyArrayList filter(Each fun) {
            MyArrayList ret = new MyArrayList();
            for (Model m : this) {
                if (!fun.one(m)) continue;
                ret.add(m);
            }
            return ret;
        }
    }

    static interface Each {
        public boolean one(Model var1);
    }
}

