/*
 * Decompiled with CFR 0.152.
 */
package org.docshare.orm;

import com.alibaba.fastjson.JSON;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.docshare.log.Log;
import org.docshare.mvc.Config;
import org.docshare.orm.ArrayTool;
import org.docshare.orm.ColumnDesc;
import org.docshare.orm.DBHelper;
import org.docshare.orm.DelegateFactory;
import org.docshare.orm.IDBDelegate;
import org.docshare.orm.LasyList;
import org.docshare.orm.Model;
import org.docshare.util.BeanUtil;
import org.docshare.util.FileTool;

public class DBTool {
    private String tname;
    private HashMap<String, Object> columns;
    public Map<String, ColumnDesc> c_to_remarks;
    String key;
    IDBDelegate delegate = DelegateFactory.getIns(Config.dbtype);
    static ConcurrentHashMap<String, DBTool> toolCache = new ConcurrentHashMap();

    public IDBDelegate getDelegate() {
        return this.delegate;
    }

    private DBTool(String tname) {
        Log.v("create a DBTool of " + tname);
        this.tname = tname;
        this.c_to_remarks = "rawsql".equals(tname) ? new HashMap<String, ColumnDesc>() : this.delegate.listColumn(tname, true);
        this.columns = new HashMap();
        for (String s : this.c_to_remarks.keySet()) {
            this.columns.put(s, null);
        }
        if (!tname.equals("rawsql")) {
            this.key = this.delegate.keyColumn(tname);
        }
    }

    public String getColumnRemark(String column) {
        return this.c_to_remarks.get((Object)column).remark;
    }

    public int getColumnType(String column) {
        return this.c_to_remarks.get((Object)column).type;
    }

    public String getColumnTypeName(String column) {
        ColumnDesc d = this.c_to_remarks.get(column);
        if (d == null) {
            Log.d("getColumnTypeName find null " + column + " reload column info ");
            this.c_to_remarks = this.delegate.listColumn(this.tname, false);
            Log.d("reload data = " + JSON.toJSONString(this.c_to_remarks));
            d = this.c_to_remarks.get(column);
            if (d == null) {
                Log.d("getColumnTypeName is null again ,return varchar" + column);
            }
            return "varchar";
        }
        return d.typeName;
    }

    public Set<String> listColumns() {
        return this.columns.keySet();
    }

    @Deprecated
    public static LasyList fromSQL(String sql) {
        return LasyList.fromRawSql(sql);
    }

    public Model get(Object id) {
        return this.get(this.key, id);
    }

    public Model getNotNull(Object id) {
        Model m = this.get(id);
        if (m == null) {
            m = new Model(this.tname, this.columns);
            m.isNull = true;
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model get(String column, Object value) {
        ResultSet rs = null;
        try {
            rs = this.delegate.resultById(this.tname, column, value);
            Model tb = null;
            if (rs.next()) {
                tb = this.db2Table(rs);
            }
            rs.close();
            Model model = tb;
            FileTool.safelyClose(rs);
            return model;
        }
        catch (SQLException e) {
            Log.e(e);
        }
        finally {
            FileTool.safelyClose(rs);
        }
        return null;
    }

    public Model create() {
        Model model = new Model(this.tname, this.columns);
        model.isCreated = true;
        model.joined_tool = this;
        return model;
    }

    public int save(Model m) {
        return this.save(m, false);
    }

    public Model saveAndRet(Model m) {
        this.save(m, false);
        return m;
    }

    public int save(Object obj, boolean isInsert) {
        Model m = Model.fromObject(this.tname, obj);
        int r = this.save(m, isInsert);
        if (r != 0) {
            String key = m.key();
            BeanUtil.set(obj, key, m.get(key));
        }
        return r;
    }

    public int save(Object obj) {
        return this.save(obj, false);
    }

    public int save(Model m, boolean isInsert) {
        if (m == null) {
            Log.e("DBTool save a null model " + m + ", tname is " + this.tname);
            return 0;
        }
        if (this.key == null) {
            Log.e("DBTool.save table must has a Key ,\u6570\u636e\u5e93\u8868\u5fc5\u987b\u6709\u4e3b\u952e");
            return 0;
        }
        int r = this.delegate.save(this, m, this.key, isInsert);
        m.isCreated = false;
        return r;
    }

    public int insert(Model m) {
        return this.save(m, true);
    }

    public Model insertAndRet(Model m) {
        this.insert(m);
        return m;
    }

    public LasyList all() {
        LasyList list = new LasyList(this, this.tname);
        return list;
    }

    public Model db2Table(ResultSet rs, Map<String, ?> c, Set<String> column_set) {
        if (c == null) {
            c = this.columns;
        }
        Model tb = new Model(this.tname, c);
        tb.joined_tool = this;
        for (String key : c.keySet()) {
            Object v = null;
            try {
                if (column_set == null || column_set.contains(key)) {
                    v = rs.getObject(key);
                }
            }
            catch (SQLException e) {
                Log.e(e);
            }
            tb.innerPut(key, v);
        }
        return tb;
    }

    private Model db2Table(ResultSet rs) {
        return this.db2Table(rs, this.columns, null);
    }

    public int del(Object id) {
        return this.delegate.delete(this.tname, this.key, id);
    }

    public int delBy(String column, Object val) {
        return this.delegate.delete(this.tname, column, val);
    }

    public int del(Model m) {
        Object kv = m.get(this.key);
        if (kv != null) {
            return this.del(kv);
        }
        return 0;
    }

    protected void finalize() throws Throwable {
        Log.d("dbtool finalize called");
        try {
            DBHelper.removeThreadLocal();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.finalize();
    }

    public ColumnDesc getColumnDesc(String column) {
        return this.c_to_remarks.get(column);
    }

    public int run(String sql, Object ... objects) {
        Log.i("DBTool run :", sql, "  param=[", ArrayTool.join(",", objects) + "]");
        return DBHelper.getIns().update(sql, objects);
    }

    public static DBTool getIns(String tname) {
        DBTool ret;
        if ("rawsql".equals(tname)) {
            return new DBTool(tname);
        }
        if (toolCache.containsKey(tname)) {
            ret = toolCache.get(tname);
        } else {
            ret = new DBTool(tname);
            toolCache.put(tname, ret);
        }
        return ret;
    }

    public static void clearCache() {
        toolCache.clear();
    }

    public DBTool tran() {
        this.delegate.beginTransaction();
        return this;
    }

    public DBTool commit() {
        this.delegate.commit();
        return this;
    }

    public DBTool rollback() {
        this.delegate.rollback();
        return this;
    }
}

