/*
 * Decompiled with CFR 0.152.
 */
package org.docshare.orm;

import com.alibaba.fastjson.JSON;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.docshare.log.Log;
import org.docshare.mvc.Config;
import org.docshare.mvc.except.MVCException;
import org.docshare.orm.ColumnDesc;
import org.docshare.orm.ColumnSave;
import org.docshare.orm.access.AccessDBHelper;
import org.docshare.orm.mysql.MySQLDBHelper;
import org.docshare.orm.postgres.PostgresDBHelper;
import org.docshare.util.FileTool;
import org.docshare.util.TextTool;

public abstract class DBHelper {
    public static final String DB_MYSQL = "mysql";
    public static final String DB_POSTGRES = "postgres";
    static ThreadLocal<DBHelper> locals = new ThreadLocal();
    public static boolean useCache = true;
    protected Connection con = null;
    protected Object last_id;
    ArrayList<Object> oneArray = new ArrayList(1);
    ArrayList<Object> twoArray = new ArrayList(2);
    private Map<String, HashMap<String, ColumnDesc>> desc_cached = new HashMap<String, HashMap<String, ColumnDesc>>();
    public static boolean useConfigFile = true;

    public static DBHelper getIns(String type) {
        DBHelper ins = locals.get();
        if (ins == null || !useCache) {
            if (type == null || type.equals(DB_MYSQL)) {
                try {
                    Class<?> cls = Class.forName("org.docshare.orm.mysql.DruidHelper");
                    Method m = cls.getDeclaredMethod("getIns", new Class[0]);
                    ins = (DBHelper)m.invoke(null, null);
                    Log.i((Object)"connect db use Druid");
                }
                catch (Exception e) {
                    Log.i((Object)"use normal MySQLDBHelper");
                    ins = new MySQLDBHelper();
                }
            } else if (type.equals(DB_POSTGRES)) {
                ins = new PostgresDBHelper();
            } else if (type.equals("access")) {
                ins = new AccessDBHelper();
            }
            locals.set(ins);
        }
        return ins;
    }

    public static DBHelper getIns() {
        return DBHelper.getIns(Config.dbtype);
    }

    public Connection getConnection() {
        return this.con;
    }

    public static void disableCache() {
        useCache = false;
    }

    public static void removeThreadLocal() {
        try {
            locals.remove();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract void conn();

    public void getFKey(String table, HashMap<String, ColumnDesc> map) throws SQLException {
        this.conn();
        DatabaseMetaData databaseMetaData = this.con.getMetaData();
        ResultSet rs = databaseMetaData.getImportedKeys(Config.dbname, this.con.getSchema(), table);
        while (rs.next()) {
            String pk_table = rs.getString("PKTABLE_NAME");
            String pk_column = rs.getString("PKCOLUMN_NAME");
            String my_column = rs.getString("FKCOLUMN_NAME");
            ColumnDesc desc = map.get(my_column);
            if (desc == null) continue;
            desc.pk_column = pk_column;
            desc.pk_table = pk_table;
        }
        rs.close();
        rs = databaseMetaData.getExportedKeys(Config.dbname, null, table);
        while (rs.next()) {
            ColumnDesc.ExportTo eTo = new ColumnDesc.ExportTo();
            String pkColumnName = rs.getString("PKCOLUMN_NAME");
            String fkTableName = rs.getString("FKTABLE_NAME");
            String fkColumnName = rs.getString("FKCOLUMN_NAME");
            eTo.table = fkTableName;
            eTo.column = fkColumnName;
            ColumnDesc desc = map.get(pkColumnName);
            if (desc == null) continue;
            if (desc.exportKey == null) {
                desc.exportKey = new ArrayList();
            }
            desc.exportKey.add(eTo);
        }
        rs.close();
    }

    public ResultSet getPrepareRS(String sql, Object obj) throws SQLException {
        this.oneArray.set(0, obj);
        return this.getRS(sql, this.oneArray);
    }

    public ResultSet getPrepareRS(String sql, Object a, Object b) throws SQLException {
        this.twoArray.clear();
        this.twoArray.set(0, a);
        this.twoArray.set(0, b);
        return this.getRS(sql, this.twoArray);
    }

    public ResultSet getRS(String sql) throws SQLException {
        this.conn();
        Statement s = this.con.createStatement();
        Log.d("DBHelper Exec : " + sql);
        return s.executeQuery(sql);
    }

    public List<TableInfo> getTables() {
        this.conn();
        ArrayList<TableInfo> ret = new ArrayList<TableInfo>();
        try {
            ResultSet rs = this.con.getMetaData().getTables(Config.dbname, Config.dbschema, null, new String[]{"TABLE", "VIEW"});
            while (rs.next()) {
                TableInfo tInfo = new TableInfo();
                tInfo.name = rs.getString("TABLE_NAME");
                tInfo.schema = rs.getString("TABLE_SCHEM");
                tInfo.type = rs.getString("TABLE_TYPE");
                ret.add(tInfo);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new MVCException("Fail to get  meta data of tables", e);
        }
        return ret;
    }

    public HashMap<String, ColumnDesc> columeOfRs(String sql, ResultSet rs) {
        HashMap<String, ColumnDesc> ret = new HashMap<String, ColumnDesc>();
        try {
            ResultSetMetaData m = rs.getMetaData();
            int c = m.getColumnCount();
            for (int i = 1; i <= c; ++i) {
                String name = m.getColumnLabel(i);
                String tb = m.getTableName(i);
                ColumnDesc cd = new ColumnDesc(name, m.getColumnType(i), m.getColumnLabel(i), tb);
                ret.put(name, cd);
            }
        }
        catch (SQLException e) {
            throw new MVCException("Fail to get  meta data of sql: " + sql, e);
        }
        return ret;
    }

    public void clearDescCache() {
        Log.v("clear desc cache ...");
        this.desc_cached.clear();
    }

    public Object getLastId() {
        return this.last_id;
    }

    public int updateWithArray(String sql, Object[] objs) {
        int n;
        ResultSet last = null;
        try {
            this.conn();
            this.last_id = -1;
            PreparedStatement s = this.con.prepareStatement(sql, 1);
            if (objs != null) {
                for (int i = 0; i < objs.length; ++i) {
                    s.setObject(i + 1, objs[i]);
                }
            }
            int ret = s.executeUpdate();
            last = s.getGeneratedKeys();
            this.last_id = last != null && last.next() ? last.getObject(1) : Integer.valueOf(-1);
            n = ret;
        }
        catch (SQLException e) {
            try {
                throw new MVCException(e);
            }
            catch (Throwable throwable) {
                FileTool.safelyClose(last);
                throw throwable;
            }
        }
        FileTool.safelyClose(last);
        return n;
    }

    public int update(String sql, Object ... objs) {
        return this.updateWithArray(sql, objs);
    }

    public void close() {
        try {
            Log.i((Object)"conn closed");
            if (this.con != null) {
                this.con.close();
            }
            this.con = null;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public HashMap<String, ColumnDesc> listColumn(String tb) {
        return this.listColumn(tb, true);
    }

    public HashMap<String, ColumnDesc> readColumnDesc(String tb) {
        String path = "/tbconfig/" + tb + ".json";
        InputStream in = this.getClass().getResourceAsStream(path);
        String json = FileTool.readAll(in, "utf-8");
        if (json == null) {
            Log.d("read columnSave not found " + path);
            return null;
        }
        Log.d("readed columnSave succ " + tb + ",path=" + path);
        ColumnSave save = (ColumnSave)JSON.parseObject((String)json, ColumnSave.class);
        return save.listColumn;
    }

    public HashMap<String, ColumnDesc> listColumn(String tb, boolean useCache) {
        HashMap<String, ColumnDesc> ret;
        if (useCache && this.desc_cached != null && this.desc_cached.containsKey(tb) && (ret = this.desc_cached.get(tb)).size() > 0) {
            return ret;
        }
        if (useConfigFile && (ret = this.readColumnDesc(tb)) != null) {
            this.desc_cached.put(tb, ret);
            return ret;
        }
        this.conn();
        ret = new HashMap();
        if (this.con == null) {
            return ret;
        }
        try {
            ResultSet rs = this.con.getMetaData().getColumns(Config.dbname, "%", tb, "%");
            while (rs.next()) {
                ColumnDesc desc = new ColumnDesc();
                desc.name = rs.getString("COLUMN_NAME");
                desc.remark = rs.getString("REMARKS");
                desc.type = rs.getInt("DATA_TYPE");
                desc.typeName = rs.getString("TYPE_NAME");
                if (desc.remark != null && desc.remark.length() == 0) {
                    desc.remark = null;
                }
                ret.put(desc.name, desc);
            }
            this.getFKey(tb, ret);
            this.desc_cached.put(tb, ret);
        }
        catch (SQLException e) {
            throw new MVCException("Fail to list columns of table " + tb, e);
        }
        return ret;
    }

    public String keyColumn(String tb) {
        this.conn();
        String ret = null;
        try {
            ResultSet rs = this.con.getMetaData().getPrimaryKeys(this.con.getCatalog(), this.con.getSchema(), tb);
            if (rs.next()) {
                String columnName;
                ret = columnName = rs.getString("COLUMN_NAME");
            }
            rs.close();
        }
        catch (SQLException e) {
            Log.e(e);
            System.out.println("---------- \u8fd9\u4e2a\u9519\u8bef\u7edd\u5927\u591a\u6570\u60c5\u51b5\u4e0d\u4f1a\u5f71\u54cd\u7a0b\u5e8f\u7684\u6b63\u5e38\u8fd0\u884c\uff0c\u9519\u8bef\u539f\u56e0\uff1a\u53ea\u662f\u83b7\u53d6\u4e0d\u5230\u8868" + tb + "\u7684\u4e3b\u952e");
        }
        return ret;
    }

    public int getVal(String sql, String column) {
        ResultSet rs = null;
        int ret = 0;
        try {
            rs = this.getRS(sql);
            if (rs.next()) {
                ret = rs.getInt(column);
            }
        }
        catch (SQLException e) {
            throw new MVCException("Fail to getVal of column [" + column + "] from sql : " + sql, e);
        }
        finally {
            FileTool.safelyClose(rs);
        }
        return ret;
    }

    public DBHelper() {
        this.oneArray.add("aa");
        this.twoArray.add("aa");
        this.twoArray.add("bb");
    }

    protected void finalize() throws Throwable {
        Log.v("DBHelper cleared");
        this.close();
        super.finalize();
    }

    protected void printParams(String sql, List<Object> params) {
        Log.d("PrintParams: " + sql + " params= {" + TextTool.join(params, ",") + "}");
    }

    public ResultSet getRS(String sql, List<Object> params) throws SQLException {
        this.printParams(sql, params);
        this.conn();
        PreparedStatement s = this.con.prepareStatement(sql);
        for (int i = 0; i < params.size(); ++i) {
            s.setObject(i + 1, params.get(i));
        }
        return s.executeQuery();
    }

    public void beginTransation() {
        try {
            this.con.setAutoCommit(false);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void commit() {
        try {
            this.con.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            this.con.setAutoCommit(true);
        }
        catch (SQLException e) {
            throw new MVCException("Fail to commit ", e);
        }
    }

    public void rollback() {
        try {
            this.con.rollback();
            this.con.setAutoCommit(true);
        }
        catch (SQLException e) {
            throw new MVCException("Fail to rollback ", e);
        }
    }

    public class TableInfo {
        public String name;
        public String schema;
        public String type;
    }
}

