/*
 * Decompiled with CFR 0.152.
 */
package org.docshare.orm;

import com.alibaba.fastjson.JSON;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import org.docshare.log.Log;
import org.docshare.mvc.Config;
import org.docshare.orm.ColumnDesc;
import org.docshare.orm.ColumnSave;
import org.docshare.orm.DBHelper;
import org.docshare.orm.Model;
import org.docshare.util.BeanUtil;
import org.docshare.util.FileTool;
import org.docshare.util.PropLoader;
import org.docshare.util.TextTool;

public class ConfigCreator {
    static Scanner sc = new Scanner(System.in);

    static String read(String msg, String def) {
        System.out.print(msg + "\u9ed8\u8ba4\u4e3a: [" + def + "]: ");
        String line = sc.nextLine();
        if (line.length() == 0) {
            return def;
        }
        return line;
    }

    public void testRead() {
        String s = FileTool.readResource("tbconfig/book.json", "utf-8");
        Log.i((Object)s);
    }

    public static void main(String[] args) throws SQLException, MalformedTemplateNameException, ParseException, TemplateException, IOException {
        PropLoader.loadToStatic("/last.properties", Config.class);
        System.out.print("\u8bf7\u8f93\u5165\u6570\u636e\u5e93\u4fe1\u606f\uff0c\u5982\u4e0e\u4e2d\u62ec\u53f7\u4e2d\u76f8\u540c\uff0c\u53ef\u4ee5\u76f4\u63a5\u6253\u56de\u8f66");
        Config.dbhost = ConfigCreator.read("\u8bf7\u8f93\u5165\u670d\u52a1\u5668\u57df\u540d\u6216ip", Config.dbhost);
        Config.dbname = ConfigCreator.read("\u8bf7\u8f93\u5165\u6570\u636e\u5e93\u540d", Config.dbname);
        Config.dbport = ConfigCreator.read("\u8bf7\u8f93\u5165\u7aef\u53e3\u53f7", Config.dbport);
        Config.dbpwd = ConfigCreator.read("\u8bf7\u8f93\u5165\u5bc6\u7801", Config.dbpwd);
        Config.dbusr = ConfigCreator.read("\u8bf7\u8f93\u5165\u7528\u6237\u540d", Config.dbusr);
        Config.dbtype = ConfigCreator.read("\u8bf7\u8f93\u5165\u7c7b\u578b", Config.dbtype);
        DBHelper helper = DBHelper.getIns();
        List<DBHelper.TableInfo> table_arr = helper.getTables();
        FileTool.makeDir("tbconfig");
        for (DBHelper.TableInfo tb : table_arr) {
            HashMap<String, ColumnDesc> listColumn = helper.listColumn(tb.name);
            String json = JSON.toJSONString((Object)new ColumnSave(tb.name, listColumn));
            String fname = "tbconfig/" + tb.name + ".json";
            FileTool.writeUTF(fname, json);
            System.out.println("write " + fname);
        }
        System.out.print("\u8bf7\u8f93\u5165\u9700\u8981\u751f\u6210\u7684\u7c7b\u7684\u5305\u540d:");
        String pkg = sc.next();
        if (pkg.length() == 0) {
            System.out.println("\u60a8\u6ca1\u6709\u8f93\u5165\u5305\u540d\uff0c\u53d6\u6d88\u751f\u6210");
            return;
        }
        String dir = "src/" + pkg.replace(".", "/") + "/";
        FileTool.makeDir(dir);
        Configuration fmCfg = new Configuration(Configuration.VERSION_2_3_25);
        fmCfg.setDefaultEncoding("utf-8");
        ClassTemplateLoader ctl = new ClassTemplateLoader(ConfigCreator.class, "/org/docshare/orm");
        fmCfg.setTemplateLoader((TemplateLoader)ctl);
        for (DBHelper.TableInfo tb : table_arr) {
            HashMap<String, ColumnDesc> listColumn = helper.listColumn(tb.name);
            String clsName = ConfigCreator.tb2Name(tb.name);
            HashMap<String, Object> root = new HashMap<String, Object>();
            HashMap<String, HashMap<String, Object>> mapColumns = new HashMap<String, HashMap<String, Object>>();
            HashMap<String, Foreign> mapForeign = new HashMap<String, Foreign>();
            for (String c : listColumn.keySet()) {
                ColumnDesc cDesc = listColumn.get(c);
                HashMap<String, Object> m = BeanUtil.obj2Map(cDesc);
                String jtype = cDesc.javaType();
                if ("DateTime".equals(jtype)) {
                    jtype = "Date";
                }
                m.put("javaType", jtype);
                mapColumns.put(c, m);
                if (cDesc.pk_column == null) continue;
                mapForeign.put(cDesc.name, new Foreign(ConfigCreator.tb2Name(cDesc.pk_table), cDesc.pk_column, cDesc.pk_table));
            }
            root.put("clsName", clsName);
            root.put("columns", mapColumns);
            root.put("importForeign", mapForeign);
            root.put("tb", tb.name);
            root.put("pkg", pkg);
            root.put("key", Model.tool((String)tb.name).key);
            String fname = dir + clsName + ".java";
            PrintWriter out = new PrintWriter(fname, "utf-8");
            fmCfg.getTemplate("clz.flt").process(root, (Writer)out);
            out.close();
        }
    }

    public static String tb2Name(String tb) {
        String[] ta = tb.split("_");
        for (int i = 0; i < ta.length; ++i) {
            ta[i] = TextTool.firstUpper(ta[i]);
        }
        String cls = TextTool.join(ta, "");
        return cls;
    }

    public static class Foreign {
        public String javaType;
        public String fk_column;
        public String fk_table;

        public Foreign(String javaType, String fk_column, String fk_table) {
            this.javaType = javaType;
            this.fk_column = fk_column;
            this.fk_table = fk_table;
        }

        public String getJavaType() {
            return this.javaType;
        }

        public String getFk_column() {
            return this.fk_column;
        }

        public String getFk_table() {
            return this.fk_table;
        }
    }
}

