/*
 * Decompiled with CFR 0.152.
 */
package org.docshare.mvc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.docshare.log.Log;
import org.docshare.util.IOUtil;

public class Rewriter {
    private String root;
    RewritePair[] pairs = null;

    public Rewriter(String root) {
        this.load(root);
    }

    public InputStream tryGetInputStream(String filepath) {
        InputStream ret;
        File f = new File(filepath);
        if (f.exists()) {
            try {
                Log.d("find ", filepath, " at ", f.getAbsolutePath());
                return new FileInputStream(f);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if ((f = new File(this.root + filepath)).exists()) {
            try {
                Log.d("find ", filepath, " at ", f.getAbsolutePath());
                return new FileInputStream(f);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if ((ret = this.getClass().getResourceAsStream(filepath)) != null) {
            Log.d("find ", filepath, " at classpath");
        }
        return ret;
    }

    private void load(String root) {
        this.root = root;
        InputStream in = this.tryGetInputStream("/rewrite.txt");
        if (in == null) {
            Log.i((Object)"can not find /rewrite.txt");
            return;
        }
        String string = IOUtil.readStream(in, "utf-8");
        String[] sa = string.split("\n");
        ArrayList<RewritePair> pa = new ArrayList<RewritePair>();
        for (String line : sa) {
            int p;
            if ((line = line.trim()).length() <= 0 || (p = line.indexOf(32)) <= 0) continue;
            String from = line.substring(0, p).trim();
            Pattern pattern = Pattern.compile(from);
            String to = line.substring(p + 1).trim();
            pa.add(new RewritePair(pattern, to));
        }
        this.pairs = pa.toArray(new RewritePair[pa.size()]);
    }

    public String rewrite(String uri) {
        if (this.pairs == null) {
            return uri;
        }
        for (RewritePair p : this.pairs) {
            Matcher m = p.pattern.matcher(uri);
            String n = m.replaceFirst(p.replace);
            if (n.equals(uri)) continue;
            Log.d("Rewrite ", uri, " to ", n);
            return n;
        }
        return uri;
    }

    static class RewritePair {
        Pattern pattern;
        String replace;

        public String toString() {
            return "RewritePair [pattern=" + this.pattern + ", replace=" + this.replace + "]";
        }

        public RewritePair(Pattern pattern2, String to) {
            this.pattern = pattern2;
            this.replace = to;
        }
    }
}

