/*
 * Decompiled with CFR 0.152.
 */
package org.docshare.mvc;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.docshare.log.Log;
import org.docshare.mvc.Config;
import org.docshare.mvc.MethodAccessCacher;
import org.docshare.mvc.YangClassLoader;
import org.docshare.util.FileTool;

public class Reloader {
    protected String root;
    protected HashMap<String, Long> last_tm = new HashMap();
    ArrayList<String> reloadList = new ArrayList();
    ClassLoader loader = null;
    Class<?> clz = null;
    protected String reloadPkg;
    int loaderVersion = 0;

    public Reloader(String clsRoot, String reloadPkg) {
        this.setParam(clsRoot, reloadPkg);
    }

    Reloader() {
    }

    public void setParam(String clsRoot, String reloadPkg) {
        this.root = clsRoot;
        this.reloadPkg = reloadPkg;
    }

    public void scan(String reloadDir) {
        this.T("start scan ...");
        if (reloadDir == null) {
            reloadDir = this.root;
        }
        this.reloadList.clear();
        this.scan(new File(reloadDir));
        if (this.reloadList.size() > 0) {
            this.loader = new YangClassLoader(++this.loaderVersion, this.root, this.reloadPkg);
        }
        for (String p : this.reloadList) {
            String cname = this.path2Class(p);
            this.reloadCls(p, cname);
        }
    }

    private void scan(File reloadF) {
        File[] childs;
        for (File c : childs = reloadF.listFiles()) {
            if (c.isFile() && c.getName().endsWith(".class")) {
                this.checkFile(c);
                continue;
            }
            this.scan(c);
        }
    }

    private String path2Class(String path) {
        String t = path.replace(this.root, "");
        if ((t = t.replace("/", ".").replace("\\", ".").replace(".class", "")).startsWith(".")) {
            t = t.substring(1);
        }
        return t;
    }

    private void checkFile(File c) {
        String path = c.getAbsolutePath();
        long now = c.lastModified();
        if (this.last_tm.containsKey(path)) {
            long last = this.last_tm.get(path);
            if (now > last) {
                this.reloadList.add(path);
                this.T("find a file need to reload " + path);
                this.last_tm.put(path, now);
            }
        } else {
            this.last_tm.put(path, now);
        }
    }

    public Class<?> load(String clsName) throws ClassNotFoundException {
        if (!Config.reloadable) {
            Class<?> ret = Class.forName(clsName);
            MethodAccessCacher.putIfNoExist(clsName, ret);
        }
        ClassLoader loader = this.classIsUpdate(clsName);
        return Class.forName(clsName, true, loader);
    }

    public ClassLoader classIsUpdate(String clsName) {
        String path = this.clsToPath(clsName);
        if (!FileTool.exists(path)) {
            if (FileTool.exists("bin/") && !path.contains("bin/")) {
                path = "bin" + path;
            } else if (FileTool.exists("target/classes/")) {
                path = "target/classes" + path;
            }
        }
        File c = new File(path);
        long now = c.lastModified();
        if (this.last_tm.containsKey(path)) {
            long last = this.last_tm.get(path);
            if (now > last) {
                this.T("find a file need to reload " + path);
                this.last_tm.put(path, now);
                this.loader = new YangClassLoader(++this.loaderVersion, this.root, this.reloadPkg);
                return this.loader;
            }
        } else {
            this.last_tm.put(path, now);
        }
        if (this.loader == null) {
            this.loader = new YangClassLoader(++this.loaderVersion, this.root, this.reloadPkg);
        }
        return this.loader;
    }

    protected String clsToPath(String clsName) {
        if (!this.root.endsWith("/")) {
            this.root = this.root + "/";
        }
        return this.root + clsName.replace(".", "/") + ".class";
    }

    private void reloadCls(String fileName, String clsName) {
        try {
            this.T("reload " + clsName + " , from " + fileName);
            this.clz = this.loader.loadClass(clsName);
            this.T("load succ " + this.clz.hashCode());
        }
        catch (ClassNotFoundException e) {
            this.T("person class not found");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void T(String s) {
        System.out.println(s);
    }

    public static void main(String[] args) throws InterruptedException {
        Reloader reload = new Reloader("bin", "org");
        while (true) {
            reload.scan("bin");
            Thread.sleep(1000L);
        }
    }

    public static void startThread(String reloadDir) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                Reloader reload = new Reloader("bin", "org");
                while (true) {
                    try {
                        reload.scan("bin");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Log.i((Object)"Reloader Thread Exception ,restart 30 second later ");
                        try {
                            Thread.sleep(30000L);
                        }
                        catch (InterruptedException e1) {
                            System.out.println("Reload thread interupted");
                            return;
                        }
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        System.out.println("Reload thread interupted");
                        return;
                    }
                }
            }
        });
        t.start();
    }

    private static long getFileLastTm(String path) {
        File f = new File(path);
        if (!f.exists()) {
            return -1L;
        }
        return f.lastModified();
    }
}

