/*
 * Decompiled with CFR 0.152.
 */
package org.docshare.mvc;

import com.esotericsoftware.reflectasm.MethodAccess;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import org.docshare.log.Log;
import org.docshare.mvc.anno.Param;

public class MethodAccessCacher {
    private static HashMap<String, MethodAccess> ma_map = new HashMap();
    private static HashMap<String, Method> method_map = new HashMap();
    private static HashMap<String, MyParam[]> method_param_map = new HashMap();

    public static MethodAccess getMethodAccess(String clsName) {
        return ma_map.get(clsName);
    }

    public static Method getMethod(String clsName, String methodName) {
        return method_map.get(clsName + "." + methodName);
    }

    public static void put(String name, Class<?> clz) {
        MethodAccess access = MethodAccess.get(clz);
        ma_map.put(name, access);
        MethodAccessCacher.buildMethodMap(name, clz);
    }

    private static void buildMethodMap(String clzName, Class<?> clazz) {
        Method[] ma;
        for (Method mm : ma = clazz.getDeclaredMethods()) {
            if (!Modifier.isPublic(mm.getModifiers())) continue;
            String mname = clzName + "." + mm.getName();
            method_map.put(mname, mm);
            MethodAccessCacher.cacheMethodParam(mname, mm);
        }
    }

    public static void putIfNoExist(String clsName, Class<?> ret) {
        if (ma_map.containsKey(clsName)) {
            return;
        }
        MethodAccessCacher.put(clsName, ret);
    }

    public static MyParam[] getMethodParam(String clsName, String methodName) {
        return method_param_map.get(clsName + "." + methodName);
    }

    public static void cacheMethodParam(String mname, Method method) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        Class<?>[] types = method.getParameterTypes();
        MyParam[] mp = new MyParam[types.length];
        if (parameterAnnotations != null && parameterAnnotations.length != 0) {
            int i = 0;
            Annotation[][] annotationArray = parameterAnnotations;
            int n = annotationArray.length;
            for (int j = 0; j < n; ++j) {
                Annotation[] parameterAnnotation;
                for (Annotation annotation : parameterAnnotation = annotationArray[j]) {
                    if (!(annotation instanceof Param)) continue;
                    Param param = (Param)annotation;
                    mp[i] = new MyParam();
                    mp[i].param = param.value();
                    mp[i].type = types[i].getName();
                    break;
                }
                ++i;
            }
        }
        if (types.length > 0) {
            Parameter[] pa = method.getParameters();
            for (int i = 0; i < pa.length; ++i) {
                if (mp[i] != null) continue;
                String name = pa[i].getName();
                if (name == null) {
                    Log.e("Loader:  you should add the -parameters to javac , for details see : https://blog.csdn.net/sanyuesan0000/article/details/80618913");
                }
                mp[i] = new MyParam();
                mp[i].param = name;
                mp[i].type = types[i].getName();
            }
        }
        method_param_map.put(mname, mp);
    }

    public static class MyParam {
        public String param;
        public String type;
    }
}

