/*
 * Decompiled with CFR 0.152.
 */
package org.docshare.mvc;

import com.esotericsoftware.reflectasm.MethodAccess;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.docshare.log.Log;
import org.docshare.mvc.CallCacheMap;
import org.docshare.mvc.Config;
import org.docshare.mvc.Controller;
import org.docshare.mvc.Interceptor;
import org.docshare.mvc.MethodAccessCacher;
import org.docshare.mvc.Reloader;
import org.docshare.mvc.except.MVCException;
import org.docshare.util.TextTool;

public class Loader {
    Reloader reloader = null;
    int loaderVersion = 0;
    Map<String, Object> singleMap = new HashMap<String, Object>();

    void runPostProcessing(String uri, Controller c, Object ret) {
        for (Interceptor ic : Config.postInterceptors) {
            if (ret == null) break;
            ret = ic.postProcess(uri, c, ret);
        }
    }

    public Class<?> load(String p) throws ClassNotFoundException {
        if (this.reloader == null) {
            String reload_base = TextTool.getParentPackage(Config.controller);
            if (reload_base.equals("org") || reload_base.equals("org.docshare")) {
                Log.e("reload base can not be 'org' or 'org.docshare', so we use your controller base as reload base.");
                reload_base = Config.controller;
            }
            Log.i((Object)("reload base : " + reload_base));
            String groovy_path = Config.getProperty("groovy", null);
            if (groovy_path == null) {
                this.reloader = new Reloader("/", reload_base);
            } else {
                try {
                    this.reloader = (Reloader)Class.forName("org.docshare.mvc.GroovyReloader").newInstance();
                    this.reloader.setParam("/", reload_base);
                }
                catch (Exception e) {
                    Log.e(e);
                }
            }
            Log.i((Object)("use reloader " + this.reloader.getClass().getName()));
        }
        return this.reloader.load(p);
    }

    static boolean isGroovyObject(Object obj) {
        Class<?>[] ia;
        for (Class<?> i : ia = obj.getClass().getInterfaces()) {
            if (!i.getName().equals("groovy.lang.GroovyObject")) continue;
            return true;
        }
        return false;
    }

    public boolean call(String uri, String cname, String method, HttpServletRequest req, HttpServletResponse resp) {
        Object obj;
        Log.d("Call " + cname + ", method = " + method);
        Class<?> cz = null;
        try {
            if (this.singleMap.containsKey(cname)) {
                obj = this.singleMap.get(cname);
                cz = obj.getClass();
                ((Controller)obj).clearOutFlag();
                Log.d("Single Mode:" + cname);
            } else {
                cz = this.load(cname);
                if (cz == null) {
                    return false;
                }
                obj = cz.newInstance();
                if (!(obj instanceof Controller)) {
                    Log.e("error : The Class is not subclass of Controller: " + cname);
                    return false;
                }
                ((Controller)obj).clearOutFlag();
            }
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            if (e instanceof MVCException) {
                throw (MVCException)e;
            }
            throw new MVCException(cause);
        }
        try {
            Object ret;
            Class<?> parentCz;
            String parentClass;
            Controller ins = (Controller)obj;
            ins.setReq(req, resp);
            if (!"login".equals(method) && !ins.checkRequire()) {
                ins.actionRequire(false);
                return true;
            }
            Method m = MethodAccessCacher.getMethod(cname, method);
            if (m == null && !(parentClass = (parentCz = cz.getSuperclass()).getName()).equals("org.docshare.mvc.Controller") && (m = MethodAccessCacher.getMethod(parentClass, method)) != null) {
                cname = parentClass;
                cz = parentCz;
            }
            if (m == null) {
                String ret2 = "no such method : " + method + " , in class " + cname;
                ins.response.setStatus(500);
                this.runPostProcessing(uri, ins, ret2);
                return true;
            }
            MethodAccess access = MethodAccessCacher.getMethodAccess(cname);
            if (!this.runInterceptors(uri, ins, access, method, m)) {
                return true;
            }
            try {
                ret = this.runMethod(ins, access, m, req, cname);
            }
            catch (Exception e) {
                ret = e;
            }
            this.runPostProcessing(uri, ins, ret);
            if (ins.isSingle()) {
                this.singleMap.put(cname, ins);
                CallCacheMap.addCache(uri, cz, access, method, ins, m);
            } else {
                CallCacheMap.addCache(uri, cz, access, method, null, m);
            }
            return true;
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new MVCException(cause);
        }
    }

    public boolean runInterceptors(String uri, Controller controller, MethodAccess access, String methodName, Method m) {
        boolean result = true;
        for (Interceptor ic : Config.interceptors) {
            if (ic == null) continue;
            Log.d("Call Intercept " + ic.name());
            boolean ret = ic.intercept(uri, controller, access, methodName, m);
            if (ret) continue;
            result = false;
            break;
        }
        return result;
    }

    public Object runMethod(Object obj, MethodAccess access, Method method, HttpServletRequest req, String className) {
        Controller controller = (Controller)obj;
        if (className == null) {
            className = obj.getClass().getName();
        }
        MethodAccessCacher.MyParam[] mp = MethodAccessCacher.getMethodParam(className, method.getName());
        Object[] args = new Object[mp.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.convertTo(controller.param(mp[i].param), mp[i].type);
        }
        try {
            return access.invoke(obj, method.getName(), args);
        }
        catch (ClassCastException e) {
            Log.e("class cast exception " + e.getMessage());
            try {
                return method.invoke(obj, args);
            }
            catch (IllegalAccessException e1) {
                Log.e("IllegalAccessException " + e1);
            }
            catch (IllegalArgumentException e1) {
                Log.e("IllegalArgumentException " + e1);
            }
            catch (InvocationTargetException e1) {
                Log.e("InvocationTargetException " + e1);
            }
            return null;
        }
    }

    private Object convertTo(Object v, String type) {
        if (v == null) {
            if (type.equals("int") || type.equals("float") || type.equals("double")) {
                return -1;
            }
            return null;
        }
        String srcType = v.getClass().getName();
        if (srcType.equals(type)) {
            return v;
        }
        if (type.equals("int")) {
            return Integer.parseInt(v.toString());
        }
        if (type.equals("long")) {
            v = Long.parseLong(v + "");
        } else if (type.equals("double")) {
            v = Double.parseDouble(v + "");
        } else if (type.equals("java.lang.Integer")) {
            v = Integer.parseInt(v + "");
        } else if (type.equals(Long.class.getName())) {
            v = Long.parseLong(v + "");
        } else if (type.equals(Boolean.class.getName())) {
            v = Boolean.parseBoolean(v + "");
        } else if (type.equals(Double.class.getName())) {
            v = Double.parseDouble(v + "");
        }
        return v;
    }
}

