/*
 * Decompiled with CFR 0.152.
 */
package org.docshare.mvc;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.IOException;
import org.codehaus.groovy.control.CompilationFailedException;
import org.docshare.log.Log;
import org.docshare.mvc.Config;
import org.docshare.mvc.MethodAccessCacher;
import org.docshare.mvc.Reloader;
import org.docshare.mvc.YangClassLoader;
import org.docshare.util.FileTool;

public class GroovyReloader
extends Reloader {
    GroovyClassLoader groovyLoader = null;

    public GroovyReloader() {
    }

    public GroovyReloader(String clsRoot, String reloadPkg) {
        super(clsRoot, reloadPkg);
    }

    @Override
    public Class<?> load(String clsName) throws ClassNotFoundException {
        ClassLoader loader;
        if (!Config.reloadable) {
            Class<?> ret = Class.forName(clsName);
            MethodAccessCacher.putIfNoExist(clsName, ret);
        }
        if ((loader = this.classIsUpdate(clsName)) == this.groovyLoader) {
            String path = this.clsToPath(clsName);
            String groovy_path = Config.getProperty("groovy", "groovy");
            File c = new File(groovy_path, path.replace(".class", ".groovy"));
            if (c.exists()) {
                try {
                    return this.groovyLoader.parseClass(c);
                }
                catch (IOException | CompilationFailedException e) {
                    Log.e(e);
                }
            }
            Log.d("file path " + c.getAbsolutePath());
        }
        return Class.forName(clsName, true, loader);
    }

    @Override
    public ClassLoader classIsUpdate(String clsName) {
        String path = this.clsToPath(clsName);
        String groovy_path = Config.getProperty("groovy", "groovy");
        File c = new File(groovy_path, path.replace(".class", ".groovy"));
        if (c.exists()) {
            path = c.getAbsolutePath();
        } else if (!FileTool.exists(path) && FileTool.exists("bin/") && !path.contains("bin/")) {
            c = new File("bin", path);
        } else if (!FileTool.exists(path) && FileTool.exists("target/classes/")) {
            c = new File("target/classes", path);
        }
        long now = c.lastModified();
        if (this.last_tm.containsKey(path)) {
            long last = (Long)this.last_tm.get(path);
            if (now > last) {
                this.last_tm.put(path, now);
                return this.newLoader(c);
            }
            if (path.endsWith(".groovy")) {
                return this.groovyLoader;
            }
            return this.loader;
        }
        this.last_tm.put(path, now);
        if (path.endsWith(".groovy")) {
            return this.groovyLoader != null ? this.groovyLoader : this.newLoader(c);
        }
        return this.loader != null ? this.loader : this.newLoader(c);
    }

    private ClassLoader newLoader(File f) {
        Log.d("load new file: " + f.getAbsolutePath());
        if (f.getName().endsWith(".groovy") && f.exists()) {
            this.groovyLoader = new GroovyClassLoader();
            return this.groovyLoader;
        }
        this.loader = new YangClassLoader(++this.loaderVersion, this.root, this.reloadPkg);
        return this.loader;
    }
}

