/*
 * Decompiled with CFR 0.152.
 */
package org.docshare.mvc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import freemarker.template.Template;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileUploadException;
import org.docshare.log.Log;
import org.docshare.mvc.Config;
import org.docshare.mvc.IBean;
import org.docshare.mvc.MVCFilter;
import org.docshare.mvc.UploadProcesser;
import org.docshare.mvc.except.NullParamException;
import org.docshare.orm.DBTool;
import org.docshare.orm.LasyList;
import org.docshare.orm.Model;
import org.docshare.util.BeanUtil;
import org.docshare.util.FileTool;
import org.docshare.util.GzipUtil;
import org.docshare.util.IOUtil;
import org.docshare.util.TextTool;

public class Controller {
    private static JSP jsp_def = new JSP();
    private static final String M_FLAG = "multipart/form-data";
    public HttpServletRequest request;
    public HttpServletResponse response;
    public HttpSession session;
    protected PrintWriter writer = null;
    private Map<String, Object> paramMap = new HashMap<String, Object>();
    public ServletContext application;
    private boolean single = false;
    private HashMap<String, String> cookieMap = new HashMap();
    private boolean can_out = true;
    Map<String, Object> root = new HashMap<String, Object>();
    private String json = null;
    private static boolean enable_gzip = true;
    Require require_obj = null;

    public JSP jsp(String path) {
        return new JSP(path);
    }

    public JSP jsp() {
        return jsp_def;
    }

    public FreeMarker freemarker(String path) {
        return new FreeMarker(path);
    }

    public void putParam(String key, Object val) {
        Log.d("put param: " + key + "= " + val);
        this.paramMap.put(key, val);
    }

    public boolean isGet() {
        return this.request.getMethod().toLowerCase().equals("get");
    }

    public boolean isPost() {
        return this.request.getMethod().toLowerCase().equals("post");
    }

    public String method() {
        return this.request.getMethod();
    }

    public String getPath() {
        String uri = this.request.getRequestURI();
        return uri;
    }

    public String getDefaultTemp() {
        String uri = this.request.getRequestURI() + ".jsp";
        String context = this.request.getContextPath();
        uri = uri.replace(context, "").replace("/.jsp", "/index.jsp");
        return uri;
    }

    public LasyList page(LasyList list) {
        return this.page(list, 30);
    }

    public String getClearQuery(String q) {
        if (q == null) {
            return "";
        }
        String[] sa = q.split("&");
        if (sa == null) {
            return "";
        }
        int c = 0;
        String r = "";
        for (String s : sa) {
            if (s.length() == 0 || s.startsWith("page") || s.startsWith("pagesz")) continue;
            r = c == 0 ? "&" + s : r + "&" + s;
            ++c;
        }
        return r;
    }

    public LasyList page(LasyList list, int pagesize) {
        int total = list.size();
        Integer page = this.paramInt("page", 1);
        Integer pagesz = this.paramInt("pagesz", pagesize);
        int pagec = (int)Math.floor(total / pagesz) + 1;
        Log.d(total / pagesz);
        Integer prev = page - 1 <= 0 ? null : Integer.valueOf(page - 1);
        Integer next = page + 1 > pagec ? null : Integer.valueOf(page + 1);
        int start = page - 5 < 1 ? 1 : page - 5;
        int end = page + 5 > pagec ? pagec : page + 5;
        end = start + 10 < pagec ? start + 10 : end;
        start = end - 10 >= 0 ? end - 10 : start;
        ArrayList<Integer> pagelist = new ArrayList<Integer>();
        String query = this.request.getQueryString();
        query = this.getClearQuery(query);
        StringBuilder sb = new StringBuilder();
        sb.append("<ul class='yangmvc_page'>");
        if (prev != null) {
            sb.append(String.format("<li><a href='%s?page=%d&pagesz=%d%s'>&lt;&lt;</a></li>", this.getPath(), prev, pagesz, query));
        } else {
            sb.append("<li>&lt;&lt;</li>");
        }
        for (int i = start; i <= end; ++i) {
            pagelist.add(i);
            if (i == page) {
                sb.append("<li>" + i + "</li>");
                continue;
            }
            sb.append(String.format("<li><a href='%s?page=%d&pagesz=%d%s'>%d</a></li>", this.getPath(), i, pagesz, query, i));
        }
        if (next != null) {
            sb.append(String.format("<li><a href='%s?page=%d&pagesz=%d%s'>&gt;&gt</a></li>", this.getPath(), next, pagesz, query));
        } else {
            sb.append("<li>&gt;&gt;</li>");
        }
        sb.append("</ul>");
        this.put("page_data", sb);
        this.put("page_prev", prev);
        this.put("page_next", next);
        this.put("page_list", pagelist);
        this.put("page_now", page);
        Log.i((Object)("page_data = " + sb));
        return list.page(page, pagesz);
    }

    void clearOutFlag() {
        this.can_out = true;
    }

    @Deprecated
    protected int paramWithDefaultInt(String pname, int def) {
        String ret = this.param(pname);
        if (ret == null) {
            return def;
        }
        return Integer.parseInt(ret);
    }

    public void render() {
        this.render(this.getDefaultTemp());
    }

    public void put(String name, Object obj, Object ... others) {
        if (obj instanceof IBean) {
            Log.d(obj.getClass().getName() + " translate to map :");
            obj = BeanUtil.obj2Map(obj);
            Log.d(JSON.toJSONString(obj));
        }
        this.request.setAttribute(name, (Object)obj);
        this.root.put(name, obj);
        for (int i = 0; i < others.length - 1; i += 2) {
            obj = others[i + 1];
            name = (String)others[i];
            if (obj instanceof IBean) {
                Log.d(obj.getClass().getName() + " translate to map :");
                obj = BeanUtil.obj2Map(obj);
                Log.d(JSON.toJSONString(obj));
            }
            this.request.setAttribute(name, (Object)obj);
            this.root.put(name, obj);
        }
    }

    public void put(String name, Object obj) {
        if (obj instanceof IBean) {
            Log.d(obj.getClass().getName() + " translate to map :");
            obj = BeanUtil.obj2Map(obj);
            Log.d(JSON.toJSONString(obj));
        }
        this.request.setAttribute(name, (Object)obj);
        this.root.put(name, obj);
    }

    public void putModelItem(Model m) {
        for (String k : m.keySet()) {
            this.put(k, m.get(k));
        }
    }

    public boolean existFile(String path) {
        String p = this.request.getRealPath(path);
        if (p == null) {
            try {
                return null != this.application.getResource(path);
            }
            catch (MalformedURLException e) {
                return false;
            }
        }
        return new File(p).exists();
    }

    public void render(String view) {
        if (!this.can_out) {
            try {
                this.outMutiOutErr("view " + view);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        this.can_out = false;
        String path = Config.template + view;
        if (!this.existFile(path)) {
            Log.e("model file not found " + path);
            this.output("\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728:" + path);
            return;
        }
        RequestDispatcher d = this.request.getRequestDispatcher(path);
        try {
            Log.d("dispatcher to " + path);
            d.forward((ServletRequest)this.request, (ServletResponse)this.response);
        }
        catch (ServletException e) {
            Log.e(e);
        }
        catch (IOException e) {
            Log.e(e);
        }
    }

    public String paramJSON() {
        return this.json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReq(HttpServletRequest req, HttpServletResponse resp) {
        Cookie[] cookies;
        String contentType;
        this.request = req;
        this.response = resp;
        this.session = this.request.getSession();
        if (this.session != null) {
            this.application = this.session.getServletContext();
        }
        if ((contentType = this.request.getContentType()) != null && contentType.startsWith(M_FLAG)) {
            UploadProcesser processer = new UploadProcesser(this, this.request, this.response, this.application);
            try {
                processer.process();
            }
            catch (FileUploadException e) {
                String s = Log.getErrMsg(e);
                Log.e(s);
                this.output(s);
            }
        }
        if (contentType != null && (contentType.contains("application/json") || contentType.contains("text/json"))) {
            ServletInputStream in = null;
            try {
                Log.d("start read json ....");
                in = this.request.getInputStream();
                this.json = FileTool.readAll((InputStream)in, "utf-8");
                if (this.json != null) {
                    this.json = this.json.trim();
                }
                if (this.json.startsWith("{")) {
                    this.jsonToParam();
                }
                Log.d("json readed " + this.json);
            }
            catch (IOException e) {
                Log.e(e);
                e.printStackTrace();
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if ((cookies = this.request.getCookies()) != null) {
            for (Cookie c : cookies) {
                this.cookieMap.put(c.getName(), c.getValue());
            }
        }
    }

    public void jsonToParam() {
        if (this.json == null) {
            return;
        }
        JSONObject obj = JSON.parseObject((String)this.json);
        this.paramMap.putAll((Map<String, Object>)obj);
    }

    public Object sess(String key) {
        return this.session.getAttribute(key);
    }

    public void sess(String key, Object val) {
        this.session.setAttribute(key, val);
    }

    public Integer sessInt(String key) {
        return (Integer)this.sess(key);
    }

    public Double sessDouble(String key) {
        return (Double)this.sess(key);
    }

    public String sessStr(String key) {
        Object o = this.sess(key);
        return o == null ? null : o.toString();
    }

    public void removeSession(String key) {
        this.session.removeAttribute(key);
    }

    public Object app(String key) {
        return this.application.getAttribute("key");
    }

    public Integer appInt(String key) {
        return (Integer)this.app(key);
    }

    public Double appDouble(String key) {
        return (Double)this.app(key);
    }

    public String appStr(String key) {
        Object o = this.app(key);
        return o == null ? null : o.toString();
    }

    public void app(String key, Object val) {
        this.application.setAttribute(key, val);
    }

    public void removeApp(String key) {
        this.application.removeAttribute(key);
    }

    public String cookie(String key) {
        return this.cookieMap.get(key);
    }

    public String cookie(String key, Object value, int period_ms) {
        Cookie cookie = new Cookie(key, "" + value);
        cookie.setMaxAge(period_ms);
        this.response.addCookie(cookie);
        this.cookieMap.put(key, "" + value);
        return value + "";
    }

    public void removeCookie(String key) {
        this.cookie(key, null, 0);
        this.cookieMap.remove(key);
    }

    void error(String s) {
    }

    private void outMutiOutErr(String s) throws IOException {
        throw new IOException("\u7ae5\u978b\uff0c\u8bf7\u4e0d\u8981\u5728\u4e00\u4e2a\u63a7\u5236\u5668\u65b9\u6cd5\u4e2d\uff0c\u5199\u5165\u591a\u4e2a\u8f93\u51fa\u8bed\u53e5\u3002\u6bcf\u4e2a\u63a7\u5236\u5668\u6bcf\u6b21\u6267\u884c\u53ea\u80fd\u8f93\u51fa\u4e00\u6b21\u3002\u4f60\u662f\u4e0d\u662f\u5728if\u4e2d\u5fd8\u4e86\u5199return ? \n \u60a8\u8bd5\u56fe\u8f93\u51fa\uff1a" + s);
    }

    public static void enableGzip() {
        enable_gzip = true;
    }

    public static void disableGzip() {
        enable_gzip = false;
    }

    private PrintWriter getMyPrintWriter() {
        PrintWriter out = null;
        try {
            if (enable_gzip && GzipUtil.isGzipSupported(this.request)) {
                this.response.setHeader("Content-Encoding", "gzip");
                out = GzipUtil.getGzipWriter(this.response);
            } else {
                out = this.response.getWriter();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out;
    }

    public void output(String s) {
        try {
            if (!this.can_out) {
                this.outMutiOutErr(s);
                return;
            }
            this.can_out = false;
            String oldType = this.response.getContentType();
            if (oldType == null || !oldType.contains("text/plain")) {
                this.response.setContentType("text/html; charset=utf-8");
            }
            this.response.setCharacterEncoding("utf-8");
            this.writer = this.getMyPrintWriter();
            if (s == null) {
                this.writer.write("null");
            } else {
                this.writer.write(s);
            }
            this.writer.close();
        }
        catch (IOException e) {
            Log.e(e);
        }
    }

    public boolean outputBytes(byte[] ba) {
        try {
            ServletOutputStream oo = this.response.getOutputStream();
            oo.write(ba);
            oo.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void outputJSON(Object obj) {
        this.outputJSON(obj, this.param("debug") != null);
    }

    public void outputJSON(Object obj, boolean pretty) {
        try {
            this.response.setCharacterEncoding("utf-8");
            this.response.setContentType("text/json;charset=utf-8");
            this.writer = this.getMyPrintWriter();
            if (obj == null) {
                this.writer.write("{}");
            } else {
                String string = this.param("datefmt") != null ? (pretty ? JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteDateUseDateFormat}) : JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat})) : JSON.toJSONString((Object)obj, (boolean)pretty);
                this.writer.write(string);
            }
            this.writer.close();
        }
        catch (Exception e) {
            Log.e(e);
        }
    }

    public void putListTable(String name, LasyList list) {
        StringBuilder sb = new StringBuilder();
        sb.append("<table class='table table-bordered yangmvc_table '>");
        for (Model m : list) {
            sb.append("<tr>");
            for (String key : m.keySet()) {
                String sv;
                Object v = m.get(key);
                if (v == null) {
                    v = "";
                }
                if (v instanceof String && (sv = (String)v).length() > 20) {
                    v = sv.substring(0, 20) + "...";
                }
                sb.append("\t<td>" + v + "</td>\r\n");
            }
            sb.append("</tr>\r\n");
        }
        sb.append("</table>");
        this.put(name, sb.toString());
    }

    public void renderForm(Model m) {
        if (m == null) {
            this.output("\u672a\u627e\u5230\u8be5\u5bf9\u8c61");
            return;
        }
        this.renderForm(m, this.getDefaultTemp(), "");
    }

    public void renderForm(Model m, String template, String postTo) {
        StringBuilder sb = new StringBuilder();
        sb.append("<form class='yangmvc_form' method='post' action='" + postTo + "'>");
        for (String key : m.keySet()) {
            if (key.equals(m.key())) continue;
            sb.append("\n<div>\n<label>");
            sb.append(m.remark(key));
            Object v = m.get(key);
            if (v == null) {
                v = "";
            }
            sb.append(String.format("</label>\n<input type='text' name='%s' value='%s' ", key, v));
            if (key.equals(m.key())) {
                sb.append(" readonly='true' ");
            }
            sb.append("></input>\n");
            sb.append("\n</div>");
        }
        sb.append("\n<div>\n<label>");
        if (m.get(m.key()) == null) {
            sb.append("</label>\n<input type='submit'  value='\u6dfb\u52a0'></input>\n");
        } else {
            sb.append("</label>\n<input type='submit'  value='\u4fee\u6539'></input>\n");
        }
        sb.append("\n</div>");
        sb.append("\n</form>\n");
        this.put(m.getTableName() + "_form", sb.toString());
        this.render(template);
    }

    public String urlParam(String p) {
        if (this.paramMap.containsKey(p)) {
            return this.paramMap.get(p).toString();
        }
        String s = this.request.getParameter(p);
        if (s == null) {
            return null;
        }
        try {
            s = new String(s.getBytes("ISO-8859-1"), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return s;
    }

    public String param(String p) {
        if (this.paramMap.containsKey(p)) {
            return this.paramMap.get(p).toString();
        }
        return this.request.getParameter(p);
    }

    public String param(String name, String def) {
        String ret = this.param(name);
        return ret == null ? def : ret;
    }

    public Integer paramInt(String p) {
        String s = this.param(p);
        if (s != null) {
            return Integer.parseInt(s);
        }
        return null;
    }

    public Integer paramInt(String p, int def) {
        String ret = this.param(p);
        if (ret == null) {
            return def;
        }
        return Integer.parseInt(ret);
    }

    public Model paramToModel(Model m) {
        for (String k : m.keySet()) {
            String v;
            if (k.equals(m.key()) && this.param(k) == null || (v = this.param(k)) == null) continue;
            m.put(k, (Object)v);
        }
        return m;
    }

    public <T> T paramToObj(T obj, String prefix) {
        List<String> props = BeanUtil.propList(obj);
        for (String p : props) {
            String v = this.param(prefix + p);
            if (v == null) continue;
            BeanUtil.set(obj, p, v);
        }
        return obj;
    }

    public void dumpParam() {
        Map map = this.request.getParameterMap();
        Log.d("----------DumpParam---------");
        Log.d("request param=" + JSON.toJSONString((Object)map));
        Log.d("paramMap=" + JSON.toJSONString(this.paramMap));
    }

    public Map<String, String[]> getParamMap() {
        HashMap<String, String[]> ret = new HashMap<String, String[]>();
        ret.putAll(this.request.getParameterMap());
        for (String key : this.paramMap.keySet()) {
            String[] sa = new String[]{"" + this.paramMap.get(key)};
            ret.put(key, sa);
        }
        return ret;
    }

    public <T> T paramToObj(T obj) {
        return this.paramToObj(obj, "");
    }

    public void checkNull(String name, Object obj) throws NullParamException {
        if (obj == null) {
            String msg = "Param should not be NULL: " + name;
            if (this.getLang().contains("zh")) {
                msg = "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a.\u8fd9\u4e2a\u95ee\u9898\u4e00\u822c\u662f\u7f3a\u5c11url\u53c2\u6570\u6216form\u8868\u5355\u53c2\u6570\u6240\u81f4" + name;
            }
            throw new NullParamException(msg);
        }
    }

    public void jump(String url) {
        try {
            if (!this.can_out) {
                this.outMutiOutErr("jump to url");
                return;
            }
            this.can_out = false;
            this.response.sendRedirect(url);
        }
        catch (IOException e) {
            Log.e(e);
        }
    }

    public void setSingle(boolean single) {
        this.single = single;
    }

    public boolean isSingle() {
        return this.single;
    }

    public String getLang() {
        String lang = this.request.getHeader("Accept-Language");
        if (lang == null) {
            return "en";
        }
        if (lang.contains(";")) {
            lang = TextTool.getBefore(lang, ";");
        }
        return lang;
    }

    public void require(String session_key, Object value, String jump_url, String err) {
        this.require_obj = new Require();
        this.require_obj.key = session_key;
        this.require_obj.value = value;
        this.require_obj.jump_url = jump_url;
        this.require_obj.err = err;
    }

    public void require(String session_key, String jump_url) {
        this.require(session_key, null, jump_url, "");
    }

    boolean checkRequire() {
        if (this.require_obj == null || this.require_obj.key == null) {
            return true;
        }
        Object obj = this.session.getAttribute(this.require_obj.key);
        if (this.require_obj.value == null) {
            return obj != null;
        }
        return this.require_obj.value.equals(obj);
    }

    void actionRequire(boolean succ) {
        if (succ) {
            return;
        }
        if (this.require_obj.jump_url == null) {
            this.output(this.require_obj.err);
        } else {
            this.jump(this.require_obj.jump_url);
        }
    }

    public void download(String path) {
        this.response.setContentType("application/x-download");
        String filedisplay = new File(path).getName();
        this.response.addHeader("Content-Disposition", "attachment;filename=" + filedisplay);
        try {
            this.request.getRequestDispatcher(path).forward((ServletRequest)this.request, (ServletResponse)this.response);
        }
        catch (ServletException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void header(String name, String val) {
        this.response.addHeader(name, val);
    }

    public String reqBody() {
        try {
            return IOUtil.readStream((InputStream)this.request.getInputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    private void putSession() {
        HashMap<String, Object> pMap = new HashMap<String, Object>();
        Enumeration names = this.session.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            pMap.put(name, this.session.getAttribute(name));
        }
        this.put("session", pMap);
    }

    public void renderFreeMarker(String path) {
        block3: {
            PrintWriter out = null;
            try {
                HashMap<String, Object> pMap = new HashMap<String, Object>();
                Enumeration names = this.request.getParameterNames();
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    pMap.put(name, this.request.getParameter(name));
                }
                pMap.putAll(this.paramMap);
                this.put("param", pMap);
                this.putSession();
                this.response.setContentType("text/html; charset=utf-8");
                this.response.setCharacterEncoding("utf-8");
                Template tpl = MVCFilter.getIns().getFmCfg().getTemplate(path);
                out = this.getMyPrintWriter();
                tpl.process(this.root, (Writer)out);
                ((Writer)out).close();
            }
            catch (Exception e) {
                if (out == null) break block3;
                e.printStackTrace(out);
            }
        }
    }

    public DBTool T(String tableName) {
        return Model.tool(tableName);
    }

    public LasyList L(String tableName) {
        return Model.tool(tableName).all();
    }

    public void runMethod(Method method) {
        try {
            method.invoke((Object)this, new Object[0]);
        }
        catch (Exception e) {
            Log.e(e);
        }
    }

    public String json(Object obj, boolean pretty) {
        return JSON.toJSONString((Object)obj, (boolean)pretty);
    }

    public String json(Object obj) {
        return this.json(obj, false);
    }

    public void dump() {
        Log.i((Object)this.json(this.request.getParameterMap(), true));
    }

    public static class Require {
        public String key;
        public Object value;
        public String jump_url;
        public String err;
    }

    public static class FreeMarker {
        String path;

        public FreeMarker(String path) {
            this.path = path;
        }
    }

    public static class JSP {
        String path;

        public JSP() {
        }

        public JSP(String path) {
            this.path = path;
        }
    }
}

