/*
 * Decompiled with CFR 0.152.
 */
package org.docshare.mvc;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.docshare.log.Log;
import org.docshare.mvc.BasePostIntercepter;
import org.docshare.mvc.Interceptor;
import org.docshare.mvc.URLFilter;
import org.docshare.util.BeanUtil;

public class Config {
    private static String prop_file = "/web.properties";
    private static long lastUpdate = 0L;
    public static String dbhost = "localhost";
    public static String dbusr = "root";
    public static String dbpwd = "123456";
    public static String dbname = "621m";
    public static String dbport = "3306";
    public static String encoding = "utf-8";
    public static String dbtype = "mysql";
    public static String dbschema = "public";
    public static boolean reloadable = true;
    public static boolean reload_config = false;
    public static String template;
    public static String dateFormat;
    public static String dbEncoding;
    public static String pageEncoding;
    public static String controller;
    public static boolean useSSL;
    public static ArrayList<URLFilter> urlFilters;
    public static ArrayList<Interceptor> interceptors;
    static ArrayList<Interceptor> postInterceptors;
    static Properties pro;
    private Thread reloadThread = null;

    public static String tpl_base() {
        return template;
    }

    public static void tpl_base(String s) {
        template = s;
    }

    public static String ctr_base() {
        return controller;
    }

    public static void ctr_base(String s) {
        controller = s;
    }

    public static String str() {
        String ret = "Config [\n\tdbhost=" + dbhost + ", \n\tdbname=" + dbname + ", \n\tdbusr=" + dbusr + ", \n\tdbpwd=" + dbpwd + ", \n\tport = " + dbport + ", \n\ttemplate=" + template + ", \n\tcontroller=" + controller + ",\n\treloadable=" + reloadable + ",\n\tuseSSL=" + useSSL + ",\n\tdbtype=" + dbtype + ",\n\tdbEncoding=" + dbEncoding + ",\n\tinterceptors=" + Config.getInteNames(interceptors) + ", \n\tpost-process=" + Config.getInteNames(postInterceptors) + "\n]";
        StringBuilder sb = new StringBuilder();
        sb.append(ret);
        if (pro == null) {
            Config.loadProperties("/web.properties");
        }
        for (Object s : pro.keySet()) {
            sb.append("\n" + s + "=" + pro.getProperty(s + ""));
        }
        return sb.toString();
    }

    public static void addInterceptor(Interceptor interceptor) {
        if (interceptors.contains(interceptor)) {
            return;
        }
        interceptors.add(interceptor);
        Log.d("Config.addInterceptor added, name =" + interceptor.name());
    }

    public static void removeInterceptor(Interceptor interceptor) {
        interceptors.remove(interceptor);
    }

    public static void addPostInterceptor(Interceptor interceptor, boolean addToFirst) {
        if (postInterceptors.contains(interceptor)) {
            return;
        }
        if (addToFirst) {
            postInterceptors.add(0, interceptor);
        } else {
            postInterceptors.add(interceptor);
        }
        Log.d("Config.addPostInterceptor added, name =" + interceptor.name());
    }

    public static void removePostInterceptor(Interceptor interceptor) {
        postInterceptors.remove(interceptor);
    }

    private static String getInteNames(ArrayList<Interceptor> list) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        boolean isFirst = true;
        for (Interceptor i : list) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(" , ");
            }
            sb.append(i.name());
        }
        sb.append("}");
        return sb.toString();
    }

    private static InputStream getPropertiesStream(String PROP_FILE) {
        try {
            File f = new File(PROP_FILE);
            if (f.exists()) {
                Log.d("read prop from " + f);
                lastUpdate = f.lastModified();
                return new FileInputStream(f);
            }
            f = new File("." + PROP_FILE);
            if (f.exists()) {
                Log.d("read prop from " + f);
                lastUpdate = f.lastModified();
                return new FileInputStream(f);
            }
            Log.d("class loader name " + Config.class.getClassLoader().toString());
            Log.d("try load from classpath");
            return Config.class.getResourceAsStream(PROP_FILE);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getProperty(String key, String def) {
        if (pro == null) {
            return null;
        }
        return pro.getProperty(key, def);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readProperties(String PROP_FILE) {
        Properties properties;
        InputStream in = null;
        if (PROP_FILE != null) {
            prop_file = PROP_FILE;
        } else {
            PROP_FILE = prop_file;
        }
        try {
            in = Config.getPropertiesStream(PROP_FILE);
            if (in == null) {
                Log.e("Config file NOT found : web.properties ");
                Properties properties2 = null;
                return properties2;
            }
            Log.i((Object)"Config  found ! ");
            pro = new Properties();
            pro.load(in);
            properties = pro;
        }
        catch (IOException e) {
            e.printStackTrace();
            Properties properties3 = null;
            return properties3;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        return properties;
    }

    public static boolean loadProperties(String PROP_FILE) {
        pro = Config.readProperties(PROP_FILE);
        if (pro != null) {
            Log.i((Object)"web.properties loaded ");
            BeanUtil.prop2StaticField(pro, Config.class);
            if (reload_config) {
                Config.startReloadThread();
            }
        }
        return pro != null;
    }

    private static void startReloadThread() {
        new Thread(() -> {
            try {
                Thread.sleep(5000L);
                Log.d("reload cfg");
                Config.loadProperties(null);
            }
            catch (InterruptedException e) {
                return;
            }
        }).start();
    }

    public static void main(String[] args) {
        Config.loadProperties("/web.properties");
    }

    static {
        dateFormat = null;
        dbEncoding = "utf8";
        pageEncoding = "utf-8";
        useSSL = false;
        urlFilters = new ArrayList();
        interceptors = new ArrayList();
        postInterceptors = new ArrayList();
        Config.addPostInterceptor(new BasePostIntercepter(), false);
        pro = null;
    }
}

