/*
 * Decompiled with CFR 0.152.
 */
package org.docshare.mvc;

import com.esotericsoftware.reflectasm.MethodAccess;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.docshare.log.Log;
import org.docshare.mvc.Controller;
import org.docshare.mvc.MVCFilter;

class CallCacheMap {
    static HashMap<String, CallCache> map = new HashMap();

    CallCacheMap() {
    }

    public static boolean runCallCache(String uri, HttpServletRequest req, HttpServletResponse resp) {
        if (!map.containsKey(uri)) {
            return false;
        }
        try {
            CallCache cach = map.get(uri);
            Controller ins = cach.single;
            if (ins == null) {
                ins = (Controller)cach.clazz.newInstance();
            }
            Log.d("CacheCall class=", cach.clazz.getName(), ",method=", cach.methodName);
            ins.setReq(req, resp);
            if (!"login".equals(cach.methodName) && !ins.checkRequire()) {
                ins.actionRequire(false);
                return true;
            }
            ins.clearOutFlag();
            if (!MVCFilter.loader.runInterceptors(uri, ins, cach.access, cach.methodName, cach.m)) {
                HttpSession sessNew = ins.session;
                return true;
            }
            Object ret = MVCFilter.loader.runMethod(ins, cach.access, cach.m, req, cach.clazz.getName());
            MVCFilter.loader.runPostProcessing(uri, ins, ret);
            return true;
        }
        catch (Exception e) {
            Log.e("run action method error: " + uri);
            e.printStackTrace();
            return false;
        }
    }

    public static void addCache(String uri, Class clazz, MethodAccess access, String methodName, Controller single, Method m) {
        CallCache cache = new CallCache();
        cache.clazz = clazz;
        cache.access = access;
        cache.methodName = methodName;
        cache.single = single;
        cache.m = m;
        map.put(uri, cache);
    }

    public static class CallCache {
        public String uri;
        public Class clazz;
        public Method m;
        public MethodAccess access;
        public String methodName;
        public Controller single = null;
    }
}

