package org.docshare.orm.mysql;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.alibaba.druid.util.DruidDataSourceUtils;
import org.docshare.mvc.Config;
import org.docshare.mvc.except.MVCException;
import org.docshare.util.TextTool;

import javax.sql.DataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;

public class DruidHelper extends  MySQLDBHelper{
    private DruidDataSource source;

    private  static DruidHelper ins =null;
    public static DruidHelper getIns(){
        if(ins == null) ins = new DruidHelper();
        return ins;
    }

    DruidHelper(){
        String encoding = Config.dbEncoding;
        if(encoding.contains("utf8")) encoding = "utf8";
        Properties prop = Config.readProperties("/druid.properties");
        String url = (String) prop.get("url");
        if(url == null){
            url = TextTool.concat("jdbc:mysql://",Config.dbhost,":",Config.dbport,"/",Config.dbname,"?characterEncoding=",encoding,"&useSSL=",Config.useSSL,"&serverTimezone=Asia/Shanghai").toString();
            prop.put("url", url);
        }
        if(prop.get("username")==null){
            prop.put("username", Config.dbusr);
        }

        if(prop.get("password")==null){
            prop.put("password", Config.dbpwd);
        }

        try {
            source = (DruidDataSource) DruidDataSourceFactory.createDataSource(prop);
            source.close();
        } catch (Exception e) {
            throw new MVCException(e);
        }
    }

    @Override
    public void conn() {
        try {
            con= source.getConnection();
        } catch (SQLException e) {
            throw new MVCException(e);
        }
    }


}
